/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.bgp.config;

import io.lighty.codecs.util.exception.DeserializationException;
import io.lighty.core.controller.impl.util.FileToDatastoreUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.RoutingPolicy;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InitialBgpConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(InitialBgpConfigLoader.class);
    private static final String ROUTING_POLICY_PATH = "/initial/routing-policy-config.xml";
    private final DOMDataBroker dataBroker;
    private final EffectiveModelContext modelContext;

    public InitialBgpConfigLoader(DOMDataBroker dataBroker, EffectiveModelContext modelContext) {
        this.dataBroker = dataBroker;
        this.modelContext = modelContext;
    }

    public void init() {
        this.loadInitialRoutingPolicy();
    }

    private void loadInitialRoutingPolicy() {
        try (InputStream inputStream = InitialBgpConfigLoader.class.getResourceAsStream(ROUTING_POLICY_PATH);){
            FileToDatastoreUtils.importConfigDataFile((InputStream)inputStream, (YangInstanceIdentifier)YangInstanceIdentifier.of((QName)RoutingPolicy.QNAME), (FileToDatastoreUtils.ImportFileFormat)FileToDatastoreUtils.ImportFileFormat.XML, (EffectiveModelContext)this.modelContext, (DOMDataBroker)this.dataBroker, (boolean)true);
        }
        catch (DeserializationException | IOException | ExecutionException | TimeoutException e) {
            LOG.warn("Failed to import initial BGP routing policies file {}", (Object)ROUTING_POLICY_PATH, (Object)e);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while importing initial BGP routing policies file {}", (Object)ROUTING_POLICY_PATH, (Object)e);
            Thread.currentThread().interrupt();
        }
    }
}

