/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.bgp.deployer;

import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.core.controller.api.LightyServices;
import io.lighty.modules.bgp.config.InitialBgpConfigLoader;
import io.netty.channel.EventLoopGroup;
import java.util.List;
import org.opendaylight.bgpcep.bgp.topology.provider.config.BgpTopologyDeployerImpl;
import org.opendaylight.bgpcep.bgp.topology.provider.config.Ipv4TopologyProvider;
import org.opendaylight.bgpcep.bgp.topology.provider.config.Ipv6TopologyProvider;
import org.opendaylight.bgpcep.bgp.topology.provider.config.LinkstateGraphProvider;
import org.opendaylight.bgpcep.bgp.topology.provider.config.LinkstateTopologyProvider;
import org.opendaylight.bgpcep.bgp.topology.provider.spi.BgpTopologyDeployer;
import org.opendaylight.graph.ConnectedGraphProvider;
import org.opendaylight.graph.impl.ConnectedGraphServer;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeFactory;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceProvider;
import org.opendaylight.protocol.bgp.linkstate.impl.BGPActivator;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.impl.DefaultBGPRibRoutingPolicyFactory;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.BGPRibRoutingPolicyFactory;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.SimpleStatementRegistry;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.registry.StatementRegistryConsumer;
import org.opendaylight.protocol.bgp.openconfig.spi.BGPTableTypeRegistryConsumer;
import org.opendaylight.protocol.bgp.openconfig.spi.DefaultBGPTableTypeRegistryConsumer;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionConsumerContext;
import org.opendaylight.protocol.bgp.parser.spi.pojo.DefaultBGPExtensionConsumerContext;
import org.opendaylight.protocol.bgp.rib.impl.BGPDispatcherImpl;
import org.opendaylight.protocol.bgp.rib.impl.ConstantCodecsRegistry;
import org.opendaylight.protocol.bgp.rib.impl.StrictBGPPeerRegistry;
import org.opendaylight.protocol.bgp.rib.impl.config.DefaultBgpDeployer;
import org.opendaylight.protocol.bgp.rib.impl.spi.BGPDispatcher;
import org.opendaylight.protocol.bgp.rib.impl.spi.BGPPeerRegistry;
import org.opendaylight.protocol.bgp.rib.impl.spi.CodecsRegistry;
import org.opendaylight.protocol.bgp.rib.impl.state.BGPStateCollector;
import org.opendaylight.protocol.bgp.rib.spi.DefaultRIBExtensionConsumerContext;
import org.opendaylight.protocol.bgp.rib.spi.RIBExtensionConsumerContext;
import org.opendaylight.protocol.bgp.rib.spi.state.BGPStateProvider;
import org.opendaylight.protocol.bgp.rib.spi.state.BGPStateProviderRegistry;
import org.opendaylight.protocol.bgp.route.targetcontrain.impl.activators.RIBActivator;
import org.opendaylight.protocol.bgp.route.targetcontrain.impl.activators.StatementActivator;
import org.opendaylight.protocol.bgp.route.targetcontrain.impl.activators.TableTypeActivator;
import org.opendaylight.protocol.bgp.state.StateProviderImpl;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpModule
extends AbstractLightyModule {
    private static final Logger LOG = LoggerFactory.getLogger(BgpModule.class);
    private static final String DEFAULT_BGP_NETWORK_INSTANCE_NAME = "global-bgp";
    private final SimpleStatementRegistry simpleStatementRegistry;
    private final BGPDispatcherImpl bgpDispatcher;
    private final DefaultBgpDeployer bgpDeployer;
    private final StateProviderImpl stateProvider;
    private final StrictBGPPeerRegistry peerRegistry;
    private final InitialBgpConfigLoader initialConfigLoader;
    private final BgpTopologyDeployerImpl bgpTopologyDeployer;
    private final Ipv4TopologyProvider ipv4TopologyProvider;
    private final Ipv6TopologyProvider ipv6TopologyProvider;
    private final LinkstateTopologyProvider linkstateTopologyProvider;
    private final ConnectedGraphServer graphServer;
    private final LinkstateGraphProvider linkstateGraphProvider;

    public BgpModule(EffectiveModelContext modelContext, DataBroker dataBroker, DOMDataBroker domDataBroker, BindingCodecTree codecTree, RpcProviderService rpcProvider, ClusterSingletonServiceProvider cssProvider, BindingNormalizedNodeSerializer serializer, EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        this.initialConfigLoader = new InitialBgpConfigLoader(domDataBroker, modelContext);
        this.peerRegistry = new StrictBGPPeerRegistry();
        this.bgpDispatcher = new BGPDispatcherImpl(BgpModule.createBgpExtensions(), bossGroup, workerGroup, (BGPPeerRegistry)this.peerRegistry);
        this.simpleStatementRegistry = BgpModule.createStatementRegistry(dataBroker);
        DefaultBGPRibRoutingPolicyFactory routingPolicyFactory = new DefaultBGPRibRoutingPolicyFactory(dataBroker, (StatementRegistryConsumer)this.simpleStatementRegistry);
        ConstantCodecsRegistry codecsRegistry = new ConstantCodecsRegistry(codecTree);
        BGPTableTypeRegistryConsumer tableTypeRegistryConsumer = BgpModule.createBgpTableTypes();
        BGPStateCollector stateCollector = new BGPStateCollector();
        RIBExtensionConsumerContext ribExtensionConsumerContext = BgpModule.createRibExtensions(serializer);
        this.stateProvider = new StateProviderImpl(dataBroker, 5, tableTypeRegistryConsumer, (BGPStateProvider)stateCollector, DEFAULT_BGP_NETWORK_INSTANCE_NAME);
        this.bgpDeployer = new DefaultBgpDeployer(DEFAULT_BGP_NETWORK_INSTANCE_NAME, cssProvider, rpcProvider, ribExtensionConsumerContext, (BGPDispatcher)this.bgpDispatcher, (BGPRibRoutingPolicyFactory)routingPolicyFactory, (CodecsRegistry)codecsRegistry, domDataBroker, dataBroker, tableTypeRegistryConsumer, (BGPStateProviderRegistry)stateCollector);
        this.bgpTopologyDeployer = new BgpTopologyDeployerImpl(dataBroker, cssProvider);
        this.ipv4TopologyProvider = new Ipv4TopologyProvider((BgpTopologyDeployer)this.bgpTopologyDeployer);
        this.ipv6TopologyProvider = new Ipv6TopologyProvider((BgpTopologyDeployer)this.bgpTopologyDeployer);
        this.linkstateTopologyProvider = new LinkstateTopologyProvider((BgpTopologyDeployer)this.bgpTopologyDeployer);
        this.graphServer = new ConnectedGraphServer(dataBroker);
        this.linkstateGraphProvider = new LinkstateGraphProvider((BgpTopologyDeployer)this.bgpTopologyDeployer, (ConnectedGraphProvider)this.graphServer);
    }

    public BgpModule(EffectiveModelContext modelContext, DataBroker dataBroker, DOMDataBroker domDataBroker, BindingCodecTreeFactory codecTreeFactory, BindingRuntimeContext runtimeContext, RpcProviderService rpcProvider, ClusterSingletonServiceProvider cssProvider, BindingNormalizedNodeSerializer serializer, EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        this(modelContext, dataBroker, domDataBroker, codecTreeFactory.create(runtimeContext), rpcProvider, cssProvider, serializer, bossGroup, workerGroup);
    }

    public BgpModule(LightyServices lightyServices) {
        this(lightyServices.getEffectiveModelContextProvider().getEffectiveModelContext(), lightyServices.getBindingDataBroker(), lightyServices.getClusteredDOMDataBroker(), lightyServices.getBindingCodecTreeFactory(), lightyServices.getAdapterContext().currentSerializer().getRuntimeContext(), lightyServices.getRpcProviderService(), lightyServices.getClusterSingletonServiceProvider(), lightyServices.getBindingNormalizedNodeSerializer(), lightyServices.getBossGroup(), lightyServices.getWorkerGroup());
    }

    protected boolean initProcedure() {
        try {
            this.initialConfigLoader.init();
            this.simpleStatementRegistry.start();
            this.bgpDeployer.init();
            return true;
        }
        catch (Exception e) {
            LOG.warn("Failed to initialize BGPModule", (Throwable)e);
            return false;
        }
    }

    protected boolean stopProcedure() {
        boolean closeSuccess = true;
        try {
            this.simpleStatementRegistry.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to stop BGP statement registry", (Throwable)e);
            closeSuccess = false;
        }
        try {
            this.peerRegistry.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to stop BGP peer registry", (Throwable)e);
            closeSuccess = false;
        }
        try {
            this.bgpDispatcher.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to stop BGP dispatcher", (Throwable)e);
            closeSuccess = false;
        }
        try {
            this.bgpDeployer.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to stop BGP deployer", (Throwable)e);
            closeSuccess = false;
        }
        if (!this.closeTopologies()) {
            closeSuccess = false;
        }
        try {
            this.bgpTopologyDeployer.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to stop BGP topology deployer", (Throwable)e);
            closeSuccess = false;
        }
        try {
            this.stateProvider.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to stop BGP state provider", (Throwable)e);
            closeSuccess = false;
        }
        return closeSuccess;
    }

    private boolean closeTopologies() {
        boolean closeSuccess = true;
        try {
            this.ipv4TopologyProvider.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to stop BGP IPV4 topology provider", (Throwable)e);
            closeSuccess = false;
        }
        try {
            this.ipv6TopologyProvider.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to stop BGP IPV6 topology provider", (Throwable)e);
            closeSuccess = false;
        }
        try {
            this.linkstateGraphProvider.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to stop BGP link state graph provider", (Throwable)e);
            closeSuccess = false;
        }
        try {
            this.graphServer.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to stop BGP graph server", (Throwable)e);
            closeSuccess = false;
        }
        try {
            this.linkstateTopologyProvider.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to stop BGP link state topology provider", (Throwable)e);
            closeSuccess = false;
        }
        return closeSuccess;
    }

    private static RIBExtensionConsumerContext createRibExtensions(BindingNormalizedNodeSerializer serializer) {
        return new DefaultRIBExtensionConsumerContext(serializer, List.of(new org.opendaylight.protocol.bgp.inet.RIBActivator(), new RIBActivator(), new org.opendaylight.protocol.bgp.linkstate.impl.RIBActivator()));
    }

    private static BGPExtensionConsumerContext createBgpExtensions() {
        return new DefaultBGPExtensionConsumerContext(List.of(new org.opendaylight.protocol.bgp.inet.BGPActivator(), new org.opendaylight.protocol.bgp.parser.impl.BGPActivator(), new org.opendaylight.protocol.bgp.route.targetcontrain.impl.activators.BGPActivator(), new BGPActivator()));
    }

    private static BGPTableTypeRegistryConsumer createBgpTableTypes() {
        return new DefaultBGPTableTypeRegistryConsumer(List.of(new org.opendaylight.protocol.bgp.inet.TableTypeActivator(), new TableTypeActivator(), new org.opendaylight.protocol.bgp.linkstate.impl.TableTypeActivator()));
    }

    private static SimpleStatementRegistry createStatementRegistry(DataBroker dataBroker) {
        return new SimpleStatementRegistry(List.of(new org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.StatementActivator(dataBroker), new StatementActivator()));
    }
}

