/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.aaa;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import io.lighty.aaa.LocalHttpServer;
import io.lighty.server.LightyServerBuilder;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.opendaylight.aaa.api.AuthenticationService;
import org.opendaylight.aaa.api.CredentialAuth;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.IdMService;
import org.opendaylight.aaa.api.IdMServiceImpl;
import org.opendaylight.aaa.api.PasswordCredentials;
import org.opendaylight.aaa.api.StoreBuilder;
import org.opendaylight.aaa.api.TokenAuth;
import org.opendaylight.aaa.api.TokenStore;
import org.opendaylight.aaa.cert.api.ICertificateManager;
import org.opendaylight.aaa.datastore.h2.ConnectionProvider;
import org.opendaylight.aaa.datastore.h2.H2Store;
import org.opendaylight.aaa.datastore.h2.H2TokenStore;
import org.opendaylight.aaa.datastore.h2.IdmLightConfig;
import org.opendaylight.aaa.datastore.h2.IdmLightConfigBuilder;
import org.opendaylight.aaa.datastore.h2.IdmLightSimpleConnectionProvider;
import org.opendaylight.aaa.filterchain.filters.CustomFilterAdapter;
import org.opendaylight.aaa.shiro.filters.AAAShiroFilter;
import org.opendaylight.aaa.shiro.idm.IdmLightApplication;
import org.opendaylight.aaa.shiro.moon.MoonTokenEndpoint;
import org.opendaylight.aaa.shiro.oauth2.OAuth2TokenServlet;
import org.opendaylight.aaa.shiro.tokenauthrealm.ServiceLocator;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.AuthenticationManager;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.HttpBasicAuth;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.DatastoreConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.ShiroConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AAALightyShiroProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AAALightyShiroProvider.class);
    private static AAALightyShiroProvider INSTANCE;
    private static IIDMStore iidmStore;
    private final List<Handler> handlers;
    private final DataBroker dataBroker;
    private final ICertificateManager certificateManager;
    private final ShiroConfiguration shiroConfiguration;

    private AAALightyShiroProvider(DataBroker dataBroker, ICertificateManager certificateManager, CredentialAuth<PasswordCredentials> credentialAuth, ShiroConfiguration shiroConfiguration, String moonEndpointPath, String oauth2EndpointPath, DatastoreConfig datastoreConfig, String dbUsername, String dbPassword, LightyServerBuilder server) {
        this.dataBroker = dataBroker;
        this.certificateManager = certificateManager;
        this.shiroConfiguration = shiroConfiguration;
        this.handlers = new ArrayList<Handler>();
        this.injectLightyShiroProviderMethodsToOriginalProvider();
        this.initAAAonServer(server);
        if (datastoreConfig == null || !datastoreConfig.getStore().equals((Object)DatastoreConfig.Store.H2DataStore)) {
            iidmStore = null;
            Object tokenStore = null;
            LOG.info("AAA Datastore has not been initialized");
            return;
        }
        IdmLightConfig config = new IdmLightConfigBuilder().dbUser(dbUsername).dbPwd(dbPassword).build();
        iidmStore = new H2Store((ConnectionProvider)new IdmLightSimpleConnectionProvider(config));
        H2TokenStore tokenStore = new H2TokenStore(datastoreConfig.getTimeToLive().longValue(), datastoreConfig.getTimeToWait().longValue());
        this.initializeServices(credentialAuth, iidmStore, (TokenStore)tokenStore);
        LocalHttpServer httpService = new LocalHttpServer(server);
        this.registerServletContexts(httpService, moonEndpointPath, oauth2EndpointPath);
    }

    private void initAAAonServer(LightyServerBuilder server) {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        ServletContextHandler mainHandler = new ServletContextHandler((HandlerContainer)contexts, "/auth", true, false);
        ServletHolder idmLightServlet = new ServletHolder((Servlet)new ServletContainer(IdmLightApplication.class));
        idmLightServlet.setInitParameter("com.sun.jersey.api.json.POJOMappingFeature", "true");
        idmLightServlet.setInitParameter("jersey.config.server.provider.packages", "org.opendaylight.aaa.impl.provider");
        mainHandler.addServlet(idmLightServlet, "/*");
        server.addContextHandler((Handler)contexts);
        this.handlers.add((Handler)contexts);
        server.addCommonInitParameter("shiroEnvironmentClass", "org.opendaylight.aaa.shiro.web.env.KarafIniWebEnvironment");
        server.addCommonEventListener((EventListener)new EnvironmentLoaderListener());
        FilterHolder customFilterAdapter = new FilterHolder((Filter)new CustomFilterAdapter());
        server.addCommonFilter(customFilterAdapter, "/*");
        FilterHolder shiroFilter = new FilterHolder((Filter)new AAAShiroFilter());
        server.addCommonFilter(shiroFilter, "/*");
        FilterHolder crossOriginFilter = new FilterHolder((Filter)new CrossOriginFilter());
        crossOriginFilter.setInitParameter("allowedMethods", "GET,POST,OPTIONS,DELETE,PUT,HEAD");
        crossOriginFilter.setInitParameter("allowedHeaders", "origin, content-type, accept, authorization, Authorization");
        server.addCommonFilter(crossOriginFilter, "/*");
    }

    public static CompletableFuture<AAALightyShiroProvider> newInstance(DataBroker dataBroker, ICertificateManager certificateManager, CredentialAuth<PasswordCredentials> credentialAuth, ShiroConfiguration shiroConfiguration, String moonEndpointPath, String oauth2EndpointPath, DatastoreConfig datastoreConfig, String dbUsername, String dbPassword, LightyServerBuilder server) {
        CompletableFuture<AAALightyShiroProvider> completableFuture = new CompletableFuture<AAALightyShiroProvider>();
        INSTANCE = new AAALightyShiroProvider(dataBroker, certificateManager, credentialAuth, shiroConfiguration, moonEndpointPath, oauth2EndpointPath, datastoreConfig, dbUsername, dbPassword, server);
        completableFuture.complete(INSTANCE);
        return completableFuture;
    }

    public static AAALightyShiroProvider getInstance() {
        return INSTANCE;
    }

    public DataBroker getDataBroker() {
        return this.dataBroker;
    }

    public ICertificateManager getCertificateManager() {
        return this.certificateManager;
    }

    public ShiroConfiguration getShiroConfiguration() {
        return this.shiroConfiguration;
    }

    public static IIDMStore getIdmStore() {
        return iidmStore;
    }

    public static void setIdmStore(IIDMStore store) {
        iidmStore = store;
    }

    public void close() {
        this.handlers.forEach(handler -> handler.destroy());
    }

    private void initializeServices(CredentialAuth<PasswordCredentials> credentialAuth, IIDMStore iidmStore, TokenStore tokenStore) {
        try {
            new StoreBuilder(iidmStore).initWithDefaultUsers("sdn");
        }
        catch (IDMStoreException e) {
            LOG.error("Failed to initialize data in store", (Throwable)e);
        }
        AuthenticationManager authService = AuthenticationManager.instance();
        ServiceLocator.getInstance().setAuthenticationService((AuthenticationService)authService);
        IdMServiceImpl idmService = new IdMServiceImpl(iidmStore);
        ServiceLocator.getInstance().setIdmService((IdMService)idmService);
        ServiceLocator.getInstance().setCredentialAuth(credentialAuth);
        HttpBasicAuth tokenAuth = new HttpBasicAuth();
        ArrayList tokenAuthList = Lists.newArrayList((Object[])new TokenAuth[]{tokenAuth});
        ServiceLocator.getInstance().setTokenAuthCollection((List)tokenAuthList);
        ServiceLocator.getInstance().setTokenStore(tokenStore);
    }

    private void registerServletContexts(LocalHttpServer httpService, String moonEndpointPath, String oauth2EndpointPath) {
        LOG.info("attempting registration of AAA moon, oauth2 and auth servlets");
        Preconditions.checkNotNull((Object)httpService, (Object)"httpService cannot be null");
        httpService.registerServlet(moonEndpointPath, (Servlet)new MoonTokenEndpoint(), null);
        httpService.registerServlet(oauth2EndpointPath, (Servlet)new OAuth2TokenServlet(), null);
    }

    private void injectLightyShiroProviderMethodsToOriginalProvider() {
        try {
            CtClass ctClass = ClassPool.getDefault().get("org.opendaylight.aaa.AAAShiroProvider");
            CtConstructor c = CtNewConstructor.make((String)"public AAAShiroProvider(){}", (CtClass)ctClass);
            ctClass.addConstructor(c);
            ctClass.removeMethod(ctClass.getDeclaredMethod("getInstance"));
            CtMethod getInstance = CtNewMethod.make((String)"public static org.opendaylight.aaa.AAAShiroProvider getInstance() {return new org.opendaylight.aaa.AAAShiroProvider();}", (CtClass)ctClass);
            ctClass.addMethod(getInstance);
            ctClass.removeMethod(ctClass.getDeclaredMethod("getInstanceFuture"));
            CtMethod getInstanceFuture = CtNewMethod.make((String)"public static java.util.concurrent.CompletableFuture getInstanceFuture() {java.util.concurrent.CompletableFuture completableFuture = new java.util.concurrent.CompletableFuture();completableFuture.complete(org.opendaylight.aaa.AAAShiroProvider.getInstance());return completableFuture;}", (CtClass)ctClass);
            ctClass.addMethod(getInstanceFuture);
            ctClass.removeMethod(ctClass.getDeclaredMethod("getIdmStore"));
            CtMethod getIdmStore = CtNewMethod.make((String)"public static org.opendaylight.aaa.api.IIDMStore getIdmStore() {return io.lighty.aaa.AAALightyShiroProvider.getIdmStore();}", (CtClass)ctClass);
            ctClass.addMethod(getIdmStore);
            ctClass.removeMethod(ctClass.getDeclaredMethod("setIdmStore"));
            CtMethod setIdmStore = CtNewMethod.make((String)"public static void setIdmStore(org.opendaylight.aaa.api.IIDMStore store) {return io.lighty.aaa.AAALightyShiroProvider.setIdmStore(store);}", (CtClass)ctClass);
            ctClass.addMethod(setIdmStore);
            ctClass.removeMethod(ctClass.getDeclaredMethod("getDataBroker"));
            CtMethod getDataBroker = CtNewMethod.make((String)"public org.opendaylight.controller.md.sal.binding.api.DataBroker getDataBroker() {return io.lighty.aaa.AAALightyShiroProvider.getInstance().getDataBroker();}", (CtClass)ctClass);
            ctClass.addMethod(getDataBroker);
            ctClass.removeMethod(ctClass.getDeclaredMethod("getCertificateManager"));
            CtMethod getCertificateManager = CtNewMethod.make((String)"public org.opendaylight.aaa.cert.api.ICertificateManager getCertificateManager() {return io.lighty.aaa.AAALightyShiroProvider.getInstance().getCertificateManager();}", (CtClass)ctClass);
            ctClass.addMethod(getCertificateManager);
            ctClass.removeMethod(ctClass.getDeclaredMethod("getShiroConfiguration"));
            CtMethod getShiroConfiguration = CtNewMethod.make((String)"public org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.ShiroConfiguration getShiroConfiguration() {return io.lighty.aaa.AAALightyShiroProvider.getInstance().getShiroConfiguration();}", (CtClass)ctClass);
            ctClass.addMethod(getShiroConfiguration);
            ctClass.toClass();
        }
        catch (CannotCompileException | NotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

