/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.aaa;

import com.google.common.collect.ImmutableSet;
import io.lighty.aaa.AAALightyShiroProvider;
import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.server.LightyServerBuilder;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiConsumer;
import org.opendaylight.aaa.api.CredentialAuth;
import org.opendaylight.aaa.api.PasswordCredentials;
import org.opendaylight.aaa.cert.api.ICertificateManager;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.yang.gen.v1.config.aaa.authn.encrypt.service.config.rev160915.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.DatastoreConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.ShiroConfiguration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AAALighty
extends AbstractLightyModule {
    private static final Logger LOG = LoggerFactory.getLogger(AAALighty.class);
    public static final Set<YangModuleInfo> YANG_MODELS = ImmutableSet.of((Object).YangModuleInfoImpl.getInstance(), (Object).YangModuleInfoImpl.getInstance(), (Object).YangModuleInfoImpl.getInstance());
    private final AAAShiroProviderHandler aaaShiroProviderHandler;
    private final LightyServerBuilder server;
    private final String dbPassword;
    private final String dbUsername;
    private final DatastoreConfig datastoreConfig;
    private final String oauth2EndpointPath;
    private final String moonEndpointPath;
    private final ShiroConfiguration shiroConfiguration;
    private final CredentialAuth<PasswordCredentials> credentialAuth;
    private final ICertificateManager certificateManager;
    private final DataBroker dataBroker;

    public AAALighty(DataBroker dataBroker, ICertificateManager certificateManager, CredentialAuth<PasswordCredentials> credentialAuth, ShiroConfiguration shiroConfiguration, String moonEndpointPath, String oauth2EndpointPath, DatastoreConfig datastoreConfig, String dbUsername, String dbPassword, LightyServerBuilder server) {
        this.dataBroker = dataBroker;
        this.certificateManager = certificateManager;
        this.credentialAuth = credentialAuth;
        this.shiroConfiguration = shiroConfiguration;
        this.moonEndpointPath = moonEndpointPath;
        this.oauth2EndpointPath = oauth2EndpointPath;
        this.datastoreConfig = datastoreConfig;
        this.dbUsername = dbUsername;
        this.dbPassword = dbPassword;
        this.server = server;
        this.aaaShiroProviderHandler = new AAAShiroProviderHandler();
    }

    protected boolean initProcedure() {
        CompletableFuture<AAALightyShiroProvider> newInstance = AAALightyShiroProvider.newInstance(this.dataBroker, this.certificateManager, this.credentialAuth, this.shiroConfiguration, this.moonEndpointPath, this.oauth2EndpointPath, this.datastoreConfig, this.dbUsername, this.dbPassword, this.server);
        final CountDownLatch cdl = new CountDownLatch(1);
        newInstance.whenComplete((BiConsumer)new BiConsumer<AAALightyShiroProvider, Throwable>(){

            @Override
            public void accept(AAALightyShiroProvider t, Throwable u) {
                AAALighty.this.aaaShiroProviderHandler.setAaaLightyShiroProvider(t);
                cdl.countDown();
            }
        });
        try {
            cdl.await();
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage());
            return false;
        }
        return true;
    }

    protected boolean stopProcedure() {
        this.aaaShiroProviderHandler.getAaaLightyShiroProvider().close();
        return true;
    }

    private static class AAAShiroProviderHandler {
        AAALightyShiroProvider aaaLightyShiroProvider;

        private AAAShiroProviderHandler() {
        }

        void setAaaLightyShiroProvider(AAALightyShiroProvider aaaLightyShiroProvider) {
            this.aaaLightyShiroProvider = aaaLightyShiroProvider;
        }

        AAALightyShiroProvider getAaaLightyShiroProvider() {
            return this.aaaLightyShiroProvider;
        }
    }
}

