/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.aaa.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.lighty.aaa.config.AAAConfiguration;
import io.lighty.core.controller.impl.config.ConfigurationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.opendaylight.yang.gen.v1.config.aaa.authn.encrypt.service.config.rev160915.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AAAConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AAAConfigUtils.class);
    private static final String AAA_ROOT_ELEMENT_NAME = "aaa";
    public static final Set<YangModuleInfo> YANG_MODELS = Set.of(.YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance());

    private AAAConfigUtils() {
    }

    public static AAAConfiguration getAAAConfiguration(InputStream jsonConfigInputStream) throws ConfigurationException {
        AAAConfiguration aaaConfiguration;
        JsonNode configNode;
        ObjectMapper mapper = new ObjectMapper();
        try {
            configNode = mapper.readTree(jsonConfigInputStream);
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot deserialize Json content to Json tree nodes", (Throwable)e);
        }
        if (!configNode.has(AAA_ROOT_ELEMENT_NAME)) {
            LOG.warn("Json config does not contain {} element. Using defaults.", (Object)AAA_ROOT_ELEMENT_NAME);
            return new AAAConfiguration();
        }
        JsonNode aaaNode = configNode.path(AAA_ROOT_ELEMENT_NAME);
        try {
            aaaConfiguration = (AAAConfiguration)mapper.treeToValue((TreeNode)aaaNode, AAAConfiguration.class);
        }
        catch (JsonProcessingException e) {
            throw new ConfigurationException(String.format("Cannot bind Json tree to type: %s", AAAConfiguration.class), (Throwable)e);
        }
        return aaaConfiguration;
    }

    public static AAAConfiguration createDefaultAAAConfiguration() {
        return new AAAConfiguration();
    }
}

