/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.aaa.config;

import io.lighty.aaa.encrypt.service.impl.AAAEncryptionServiceImpl;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.opendaylight.aaa.cert.api.ICertificateManager;
import org.opendaylight.aaa.cert.impl.CertificateManagerService;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.yang.gen.v1.config.aaa.authn.encrypt.service.config.rev160915.AaaEncryptServiceConfig;
import org.opendaylight.yang.gen.v1.config.aaa.authn.encrypt.service.config.rev160915.AaaEncryptServiceConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.AaaCertServiceConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.AaaCertServiceConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.CtlKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.CtlKeystoreBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.TrustKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.TrustKeystoreBuilder;

public final class CertificateManagerConfig {
    private CertificateManagerConfig() {
    }

    public static ICertificateManager getDefault(DataBroker bindingDataBroker, RpcProviderService rpcProviderService) {
        ArrayList cipherSuites = new ArrayList();
        CtlKeystore ctlKeystore = new CtlKeystoreBuilder().setName("ctl.jks").setAlias("controller").setDname("CN=ODL, OU=Dev, O=LinuxFoundation, L=QC Montreal, C=CA").setValidity(Integer.valueOf(365)).setKeyAlg("RSA").setSignAlg("SHA1WithRSAEncryption").setCipherSuites(cipherSuites).setStorePassword("").setKeysize(Integer.valueOf(1024)).build();
        TrustKeystore trustKeystore = new TrustKeystoreBuilder().setName("truststore.jks").build();
        AaaCertServiceConfig aaaCertServiceConfig = new AaaCertServiceConfigBuilder().setUseConfig(Boolean.valueOf(true)).setUseMdsal(Boolean.valueOf(true)).setBundleName("opendaylight").setCtlKeystore(ctlKeystore).setTrustKeystore(trustKeystore).build();
        AaaEncryptServiceConfig encrySrvConfig = new AaaEncryptServiceConfigBuilder().setEncryptKey("V1S1ED4OMeEh").setPasswordLength(Integer.valueOf(12)).setEncryptSalt("TdtWeHbch/7xP52/rp3Usw==").setEncryptMethod("PBKDF2WithHmacSHA1").setEncryptType("AES").setEncryptIterationCount(Integer.valueOf(32768)).setEncryptKeyLength(Integer.valueOf(128)).setCipherTransforms("AES/CBC/PKCS5Padding").build();
        byte[] encryptionKeySalt = Base64.getDecoder().decode(encrySrvConfig.getEncryptSalt());
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(encrySrvConfig.getEncryptMethod());
            PBEKeySpec keySpec = new PBEKeySpec(encrySrvConfig.getEncryptKey().toCharArray(), encryptionKeySalt, encrySrvConfig.getEncryptIterationCount(), encrySrvConfig.getEncryptKeyLength());
            SecretKeySpec key = new SecretKeySpec(keyFactory.generateSecret(keySpec).getEncoded(), encrySrvConfig.getEncryptType());
            IvParameterSpec ivParameterSpec = new IvParameterSpec(encryptionKeySalt);
            Cipher encryptCipher = Cipher.getInstance(encrySrvConfig.getCipherTransforms());
            encryptCipher.init(1, (Key)key, ivParameterSpec);
            Cipher decryptCipher = Cipher.getInstance(encrySrvConfig.getCipherTransforms());
            decryptCipher.init(2, (Key)key, ivParameterSpec);
            AAAEncryptionServiceImpl encryptionSrv = new AAAEncryptionServiceImpl(encryptCipher, decryptCipher);
            return new CertificateManagerService(rpcProviderService, bindingDataBroker, (AAAEncryptionService)encryptionSrv, aaaCertServiceConfig);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e) {
            return null;
        }
    }
}

