/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.aaa;

import io.lighty.aaa.AAALightyShiroProvider;
import io.lighty.aaa.config.AAAConfiguration;
import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.server.LightyServerBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import org.opendaylight.aaa.api.CredentialAuth;
import org.opendaylight.aaa.api.PasswordCredentials;
import org.opendaylight.mdsal.binding.api.DataBroker;

public final class AAALighty
extends AbstractLightyModule {
    private final AAAShiroProviderHandler aaaShiroProviderHandler;
    private final LightyServerBuilder server;
    private final CredentialAuth<PasswordCredentials> credentialAuth;
    private final DataBroker dataBroker;
    private final AAAConfiguration aaaConfiguration;

    public AAALighty(DataBroker dataBroker, CredentialAuth<PasswordCredentials> credentialAuth, LightyServerBuilder server, AAAConfiguration config) {
        this.dataBroker = dataBroker;
        this.aaaConfiguration = config;
        this.credentialAuth = credentialAuth;
        this.server = server;
        this.aaaShiroProviderHandler = new AAAShiroProviderHandler();
    }

    protected boolean initProcedure() throws InterruptedException {
        CompletableFuture<AAALightyShiroProvider> newInstance = AAALightyShiroProvider.newInstance(this.dataBroker, this.aaaConfiguration, this.credentialAuth, this.server);
        CountDownLatch cdl = new CountDownLatch(1);
        newInstance.whenComplete((t, u) -> {
            this.aaaShiroProviderHandler.setAaaLightyShiroProvider((AAALightyShiroProvider)t);
            cdl.countDown();
        });
        cdl.await();
        return true;
    }

    protected boolean stopProcedure() {
        AAALightyShiroProvider shiroProvider = this.aaaShiroProviderHandler.getAaaLightyShiroProvider();
        if (shiroProvider != null) {
            shiroProvider.close();
            this.aaaShiroProviderHandler.setAaaLightyShiroProvider(null);
        }
        return true;
    }

    private static class AAAShiroProviderHandler {
        AAALightyShiroProvider aaaLightyShiroProvider;

        private AAAShiroProviderHandler() {
        }

        void setAaaLightyShiroProvider(AAALightyShiroProvider aaaLightyShiroProvider) {
            this.aaaLightyShiroProvider = aaaLightyShiroProvider;
        }

        AAALightyShiroProvider getAaaLightyShiroProvider() {
            return this.aaaLightyShiroProvider;
        }
    }
}

