/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.aaa;

import io.lighty.aaa.LocalHttpServer;
import io.lighty.server.LightyServerBuilder;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Application;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.glassfish.jersey.internal.guava.Preconditions;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.opendaylight.aaa.api.AuthenticationService;
import org.opendaylight.aaa.api.ClaimCache;
import org.opendaylight.aaa.api.CredentialAuth;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.IdMServiceImpl;
import org.opendaylight.aaa.api.PasswordCredentials;
import org.opendaylight.aaa.api.StoreBuilder;
import org.opendaylight.aaa.api.TokenAuth;
import org.opendaylight.aaa.api.TokenStore;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.opendaylight.aaa.cert.api.ICertificateManager;
import org.opendaylight.aaa.datastore.h2.ConnectionProvider;
import org.opendaylight.aaa.datastore.h2.H2Store;
import org.opendaylight.aaa.datastore.h2.H2TokenStore;
import org.opendaylight.aaa.datastore.h2.IdmLightConfig;
import org.opendaylight.aaa.datastore.h2.IdmLightConfigBuilder;
import org.opendaylight.aaa.datastore.h2.IdmLightSimpleConnectionProvider;
import org.opendaylight.aaa.filterchain.configuration.CustomFilterAdapterConfiguration;
import org.opendaylight.aaa.filterchain.configuration.impl.CustomFilterAdapterConfigurationImpl;
import org.opendaylight.aaa.filterchain.filters.CustomFilterAdapter;
import org.opendaylight.aaa.impl.password.service.DefaultPasswordHashService;
import org.opendaylight.aaa.shiro.filters.AAAShiroFilter;
import org.opendaylight.aaa.shiro.idm.IdmLightApplication;
import org.opendaylight.aaa.shiro.idm.IdmLightProxy;
import org.opendaylight.aaa.shiro.moon.MoonTokenEndpoint;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.AuthenticationManager;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.HttpBasicAuth;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.TokenAuthenticators;
import org.opendaylight.aaa.shiro.web.env.ShiroWebEnvironmentLoaderListener;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.DatastoreConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.ShiroConfiguration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.password.service.config.rev170619.PasswordServiceConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.password.service.config.rev170619.PasswordServiceConfigBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AAALightyShiroProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AAALightyShiroProvider.class);
    private static AAALightyShiroProvider INSTANCE;
    private IIDMStore iidmStore;
    private final List<Handler> handlers;
    private final DataBroker dataBroker;
    private final ICertificateManager certificateManager;
    private final ShiroConfiguration shiroConfiguration;
    private final AuthenticationService authenticationService;
    private final DefaultPasswordHashService defaultPasswordHashService;
    private TokenAuthenticators tokenAuthenticators;
    private CredentialAuth<PasswordCredentials> credentialAuth;
    private ClaimCache claimCache;
    private PasswordHashService passwordHashService;
    private H2TokenStore tokenStore;
    private IdMServiceImpl idmService;
    private ShiroWebEnvironmentLoaderListener shiroWebEnvironmentLoaderListener;

    private AAALightyShiroProvider(DataBroker dataBroker, ICertificateManager certificateManager, CredentialAuth<PasswordCredentials> credentialAuth, ShiroConfiguration shiroConfiguration, String moonEndpointPath, DatastoreConfig datastoreConfig, String dbUsername, String dbPassword, LightyServerBuilder server) {
        this.dataBroker = dataBroker;
        this.certificateManager = certificateManager;
        this.credentialAuth = credentialAuth;
        this.shiroConfiguration = shiroConfiguration;
        this.handlers = new ArrayList<Handler>();
        this.authenticationService = new AuthenticationManager();
        this.injectLightyShiroProviderMethodsToOriginalProvider();
        if (datastoreConfig == null || !datastoreConfig.getStore().equals((Object)DatastoreConfig.Store.H2DataStore)) {
            this.defaultPasswordHashService = null;
            this.iidmStore = null;
            this.tokenStore = null;
            LOG.info("AAA Datastore has not been initialized");
            return;
        }
        IdmLightConfig config = new IdmLightConfigBuilder().dbUser(dbUsername).dbPwd(dbPassword).build();
        PasswordServiceConfig passwordServiceConfig = new PasswordServiceConfigBuilder().setAlgorithm("SHA-512").setIterations(Integer.valueOf(20000)).build();
        this.defaultPasswordHashService = new DefaultPasswordHashService(passwordServiceConfig);
        this.iidmStore = new H2Store((ConnectionProvider)new IdmLightSimpleConnectionProvider(config), (PasswordHashService)this.defaultPasswordHashService);
        this.tokenStore = new H2TokenStore(datastoreConfig.getTimeToLive().longValue(), datastoreConfig.getTimeToWait().longValue());
        this.passwordHashService = this.defaultPasswordHashService;
        if (credentialAuth == null) {
            IdmLightProxy idmLightProxy;
            this.credentialAuth = idmLightProxy = new IdmLightProxy(this.iidmStore, (PasswordHashService)this.defaultPasswordHashService);
            this.claimCache = idmLightProxy;
        }
        this.tokenAuthenticators = AAALightyShiroProvider.buildTokenAuthenticators(this.credentialAuth);
        this.idmService = new IdMServiceImpl(this.iidmStore);
        try {
            new StoreBuilder(this.iidmStore).initWithDefaultUsers("sdn");
        }
        catch (IDMStoreException e) {
            LOG.error("Failed to initialize data in store", (Throwable)e);
        }
        LocalHttpServer httpService = new LocalHttpServer(server);
        this.registerServletContexts(httpService, moonEndpointPath);
        this.initAAAonServer(server);
    }

    private void initAAAonServer(LightyServerBuilder server) {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        ServletContextHandler mainHandler = new ServletContextHandler((HandlerContainer)contexts, "/auth", true, false);
        IdmLightApplication idmLightApplication = new IdmLightApplication(this.iidmStore, this.claimCache);
        ServletHolder idmLightServlet = new ServletHolder((Servlet)new ServletContainer(ResourceConfig.forApplication((Application)idmLightApplication)));
        idmLightServlet.setInitParameter("jersey.config.server.provider.packages", "org.opendaylight.aaa.impl.provider");
        mainHandler.addServlet(idmLightServlet, "/*");
        server.addContextHandler((Handler)contexts);
        this.handlers.add((Handler)contexts);
        this.shiroWebEnvironmentLoaderListener = new ShiroWebEnvironmentLoaderListener(this.shiroConfiguration, this.dataBroker, this.certificateManager, this.authenticationService, this.tokenAuthenticators, (TokenStore)this.tokenStore, this.passwordHashService);
        server.addCommonEventListener((EventListener)this.shiroWebEnvironmentLoaderListener);
        HashMap properties = new HashMap();
        CustomFilterAdapterConfigurationImpl customFilterAdapterConfig = new CustomFilterAdapterConfigurationImpl();
        customFilterAdapterConfig.update(properties);
        FilterHolder customFilterAdapter = new FilterHolder((Filter)new CustomFilterAdapter((CustomFilterAdapterConfiguration)customFilterAdapterConfig));
        server.addCommonFilter(customFilterAdapter, "/*");
        FilterHolder shiroFilter = new FilterHolder((Filter)new AAAShiroFilter());
        server.addCommonFilter(shiroFilter, "/*");
        FilterHolder crossOriginFilter = new FilterHolder((Filter)new CrossOriginFilter());
        crossOriginFilter.setInitParameter("allowedMethods", "GET,POST,OPTIONS,DELETE,PUT,HEAD");
        crossOriginFilter.setInitParameter("allowedHeaders", "origin, content-type, accept, authorization, Authorization");
        server.addCommonFilter(crossOriginFilter, "/*");
    }

    public static CompletableFuture<AAALightyShiroProvider> newInstance(DataBroker dataBroker, ICertificateManager certificateManager, CredentialAuth<PasswordCredentials> credentialAuth, ShiroConfiguration shiroConfiguration, String moonEndpointPath, DatastoreConfig datastoreConfig, String dbUsername, String dbPassword, LightyServerBuilder server) {
        CompletableFuture<AAALightyShiroProvider> completableFuture = new CompletableFuture<AAALightyShiroProvider>();
        INSTANCE = new AAALightyShiroProvider(dataBroker, certificateManager, credentialAuth, shiroConfiguration, moonEndpointPath, datastoreConfig, dbUsername, dbPassword, server);
        completableFuture.complete(INSTANCE);
        return completableFuture;
    }

    public static AAALightyShiroProvider getInstance() {
        return INSTANCE;
    }

    public DataBroker getDataBroker() {
        return this.dataBroker;
    }

    public ICertificateManager getCertificateManager() {
        return this.certificateManager;
    }

    public ShiroConfiguration getShiroConfiguration() {
        return this.shiroConfiguration;
    }

    public ShiroWebEnvironmentLoaderListener getShiroWebEnvironmentLoaderListener() {
        return this.shiroWebEnvironmentLoaderListener;
    }

    public TokenAuthenticators getTokenAuthenticators() {
        return this.tokenAuthenticators;
    }

    public H2TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public DefaultPasswordHashService getDefaultPasswordHashService() {
        return this.defaultPasswordHashService;
    }

    public static IIDMStore getIdmStore() {
        return AAALightyShiroProvider.INSTANCE.iidmStore;
    }

    public static void setIdmStore(IIDMStore store) {
        AAALightyShiroProvider.INSTANCE.iidmStore = store;
    }

    public void close() {
        this.handlers.forEach(handler -> handler.destroy());
    }

    private static TokenAuthenticators buildTokenAuthenticators(CredentialAuth<PasswordCredentials> credentialAuth) {
        return new TokenAuthenticators(new TokenAuth[]{new HttpBasicAuth(credentialAuth)});
    }

    private void registerServletContexts(LocalHttpServer httpService, String moonEndpointPath) {
        LOG.info("attempting registration of AAA moon and auth servlets");
        Preconditions.checkNotNull((Object)httpService, (Object)"httpService cannot be null");
        httpService.registerServlet(moonEndpointPath, (Servlet)new MoonTokenEndpoint(), null);
    }

    private void injectLightyShiroProviderMethodsToOriginalProvider() {
        try {
            CtClass ctClass = ClassPool.getDefault().get("org.opendaylight.aaa.AAAShiroProvider");
            CtConstructor c = CtNewConstructor.make((String)"public AAAShiroProvider(){}", (CtClass)ctClass);
            ctClass.addConstructor(c);
            CtMethod getInstance = CtNewMethod.make((String)"public static org.opendaylight.aaa.AAAShiroProvider getInstance() {return new org.opendaylight.aaa.AAAShiroProvider();}", (CtClass)ctClass);
            ctClass.addMethod(getInstance);
            CtMethod getInstanceFuture = CtNewMethod.make((String)"public static java.util.concurrent.CompletableFuture getInstanceFuture() {java.util.concurrent.CompletableFuture completableFuture = new java.util.concurrent.CompletableFuture();completableFuture.complete(org.opendaylight.aaa.AAAShiroProvider.getInstance());return completableFuture;}", (CtClass)ctClass);
            ctClass.addMethod(getInstanceFuture);
            CtMethod getIdmStore = CtNewMethod.make((String)"public static org.opendaylight.aaa.api.IIDMStore getIdmStore() {return io.lighty.aaa.AAALightyShiroProvider.getIdmStore();}", (CtClass)ctClass);
            ctClass.addMethod(getIdmStore);
            CtMethod setIdmStore = CtNewMethod.make((String)"public static void setIdmStore(org.opendaylight.aaa.api.IIDMStore store) {return io.lighty.aaa.AAALightyShiroProvider.setIdmStore(store);}", (CtClass)ctClass);
            ctClass.addMethod(setIdmStore);
            ctClass.removeMethod(ctClass.getDeclaredMethod("getDataBroker"));
            CtMethod getDataBroker = CtNewMethod.make((String)"public org.opendaylight.mdsal.binding.api.DataBroker getDataBroker() {return io.lighty.aaa.AAALightyShiroProvider.getInstance().getDataBroker();}", (CtClass)ctClass);
            ctClass.addMethod(getDataBroker);
            ctClass.removeMethod(ctClass.getDeclaredMethod("getCertificateManager"));
            CtMethod getCertificateManager = CtNewMethod.make((String)"public org.opendaylight.aaa.cert.api.ICertificateManager getCertificateManager() {return io.lighty.aaa.AAALightyShiroProvider.getInstance().getCertificateManager();}", (CtClass)ctClass);
            ctClass.addMethod(getCertificateManager);
            ctClass.removeMethod(ctClass.getDeclaredMethod("getShiroConfiguration"));
            CtMethod getShiroConfiguration = CtNewMethod.make((String)"public org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.ShiroConfiguration getShiroConfiguration() {return io.lighty.aaa.AAALightyShiroProvider.getInstance().getShiroConfiguration();}", (CtClass)ctClass);
            ctClass.addMethod(getShiroConfiguration);
            ctClass.removeMethod(ctClass.getDeclaredMethod("getTokenAuthenticators"));
            CtMethod getTokenAuthenticators = CtMethod.make((String)"public org.opendaylight.aaa.shiro.tokenauthrealm.auth.TokenAuthenticators getTokenAuthenticators() {return io.lighty.aaa.AAALightyShiroProvider.getInstance().getTokenAuthenticators();}", (CtClass)ctClass);
            ctClass.addMethod(getTokenAuthenticators);
            ctClass.toClass();
        }
        catch (CannotCompileException | javassist.NotFoundException | NotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

