/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.aaa.config;

import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.ShiroConfiguration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.ShiroConfigurationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.shiro.configuration.Main;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.shiro.configuration.MainBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.shiro.configuration.Urls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.shiro.configuration.UrlsBuilder;

public final class ShiroConfigurationConfig {
    private ShiroConfigurationConfig() {
    }

    public static ShiroConfiguration getDefault() {
        ArrayList<Main> mains = new ArrayList<Main>();
        mains.add(ShiroConfigurationConfig.initMain("tokenAuthRealm", "org.opendaylight.aaa.shiro.realm.TokenAuthRealm"));
        mains.add(ShiroConfigurationConfig.initMain("securityManager.realms", "$tokenAuthRealm"));
        mains.add(ShiroConfigurationConfig.initMain("authcBasic", "org.opendaylight.aaa.shiro.filters.ODLHttpAuthenticationFilter"));
        mains.add(ShiroConfigurationConfig.initMain("accountingListener", "org.opendaylight.aaa.shiro.filters.AuthenticationListener"));
        mains.add(ShiroConfigurationConfig.initMain("securityManager.authenticator.authenticationListeners", "$accountingListener"));
        mains.add(ShiroConfigurationConfig.initMain("dynamicAuthorization", "org.opendaylight.aaa.shiro.realm.MDSALDynamicAuthorizationFilter"));
        ArrayList<Urls> urls = new ArrayList<Urls>();
        urls.add(ShiroConfigurationConfig.initUrl("/operations/cluster-admin**", "authcBasic, roles[admin]"));
        urls.add(ShiroConfigurationConfig.initUrl("/v1/**", "authcBasic, roles[admin]"));
        urls.add(ShiroConfigurationConfig.initUrl("/config/aaa*/**", "authcBasic, roles[admin]"));
        urls.add(ShiroConfigurationConfig.initUrl("/**", "authcBasic, dynamicAuthorization"));
        return new ShiroConfigurationBuilder().setMain(mains).setUrls(urls).build();
    }

    private static Urls initUrl(String key, String val) {
        return new UrlsBuilder().setPairKey(key).setPairValue(val).build();
    }

    private static Main initMain(String key, String val) {
        return new MainBuilder().setPairKey(key).setPairValue(val).build();
    }
}

