/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.aaa;

import com.google.common.base.Preconditions;
import io.lighty.aaa.LocalHttpServer;
import io.lighty.server.LightyServerBuilder;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.opendaylight.aaa.api.AuthenticationService;
import org.opendaylight.aaa.api.ClaimCache;
import org.opendaylight.aaa.api.CredentialAuth;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.IdMServiceImpl;
import org.opendaylight.aaa.api.PasswordCredentials;
import org.opendaylight.aaa.api.StoreBuilder;
import org.opendaylight.aaa.api.TokenAuth;
import org.opendaylight.aaa.api.TokenStore;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.opendaylight.aaa.cert.api.ICertificateManager;
import org.opendaylight.aaa.datastore.h2.ConnectionProvider;
import org.opendaylight.aaa.datastore.h2.H2Store;
import org.opendaylight.aaa.datastore.h2.H2TokenStore;
import org.opendaylight.aaa.datastore.h2.IdmLightConfig;
import org.opendaylight.aaa.datastore.h2.IdmLightConfigBuilder;
import org.opendaylight.aaa.datastore.h2.IdmLightSimpleConnectionProvider;
import org.opendaylight.aaa.filterchain.configuration.CustomFilterAdapterConfiguration;
import org.opendaylight.aaa.filterchain.configuration.impl.CustomFilterAdapterConfigurationImpl;
import org.opendaylight.aaa.filterchain.filters.CustomFilterAdapter;
import org.opendaylight.aaa.impl.password.service.DefaultPasswordHashService;
import org.opendaylight.aaa.shiro.filters.AAAShiroFilter;
import org.opendaylight.aaa.shiro.idm.IdmLightApplication;
import org.opendaylight.aaa.shiro.idm.IdmLightProxy;
import org.opendaylight.aaa.shiro.moon.MoonTokenEndpoint;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.AuthenticationManager;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.HttpBasicAuth;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.TokenAuthenticators;
import org.opendaylight.aaa.shiro.web.env.ShiroWebEnvironmentLoaderListener;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.DatastoreConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.ShiroConfiguration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.password.service.config.rev170619.PasswordServiceConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.password.service.config.rev170619.PasswordServiceConfigBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AAALightyShiroProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AAALightyShiroProvider.class);
    private static AAALightyShiroProvider INSTANCE;
    private IIDMStore iidmStore;
    private final List<Handler> handlers;
    private final DataBroker dataBroker;
    private final ICertificateManager certificateManager;
    private final ShiroConfiguration shiroConfiguration;
    private AuthenticationManager authenticationManager;
    private TokenAuthenticators tokenAuthenticators;
    private PasswordHashService passwordHashService;
    private CredentialAuth<PasswordCredentials> credentialAuth;
    private ClaimCache claimCache;
    private TokenStore tokenStore;
    private IdMServiceImpl idmService;

    private AAALightyShiroProvider(DataBroker dataBroker, ICertificateManager certificateManager, CredentialAuth<PasswordCredentials> credentialAuth, ShiroConfiguration shiroConfiguration, String moonEndpointPath, DatastoreConfig datastoreConfig, String dbUsername, String dbPassword, LightyServerBuilder server, IIDMStore store, PasswordHashService passHashService) {
        this.dataBroker = dataBroker;
        this.certificateManager = certificateManager;
        this.credentialAuth = credentialAuth;
        this.shiroConfiguration = shiroConfiguration;
        this.handlers = new ArrayList<Handler>();
        this.authenticationManager = new AuthenticationManager();
        this.injectLightyShiroProviderMethodsToOriginalProvider();
        if (datastoreConfig != null && datastoreConfig.getStore().equals((Object)DatastoreConfig.Store.H2DataStore)) {
            if (store != null) {
                this.passwordHashService = (PasswordHashService)Preconditions.checkNotNull((Object)passHashService);
                this.iidmStore = store;
            } else {
                IdmLightConfig config = new IdmLightConfigBuilder().dbUser(dbUsername).dbPwd(dbPassword).build();
                PasswordServiceConfig passwordServiceConfig = new PasswordServiceConfigBuilder().setAlgorithm("SHA-512").setIterations(Integer.valueOf(20000)).build();
                this.passwordHashService = new DefaultPasswordHashService(passwordServiceConfig);
                this.iidmStore = new H2Store((ConnectionProvider)new IdmLightSimpleConnectionProvider(config), this.passwordHashService);
            }
        } else {
            this.iidmStore = null;
            this.tokenStore = null;
            LOG.info("AAA DataStore has not been initialized");
            return;
        }
        this.tokenStore = new H2TokenStore(datastoreConfig.getTimeToLive().longValue(), datastoreConfig.getTimeToWait().longValue());
        if (credentialAuth == null) {
            IdmLightProxy idmLightProxy;
            this.credentialAuth = idmLightProxy = new IdmLightProxy(this.iidmStore, this.passwordHashService);
            this.claimCache = idmLightProxy;
            HttpBasicAuth basicAuth = new HttpBasicAuth((CredentialAuth)idmLightProxy);
            this.tokenAuthenticators = new TokenAuthenticators(new TokenAuth[]{basicAuth});
        } else {
            if (credentialAuth instanceof ClaimCache) {
                this.claimCache = (ClaimCache)credentialAuth;
            }
            HttpBasicAuth basicAuth = new HttpBasicAuth(credentialAuth);
            this.tokenAuthenticators = new TokenAuthenticators(new TokenAuth[]{basicAuth});
        }
        this.initAAAonServer(server, this.passwordHashService);
        this.idmService = new IdMServiceImpl(this.iidmStore);
        try {
            new StoreBuilder(this.iidmStore).initWithDefaultUsers("sdn");
        }
        catch (IDMStoreException e) {
            LOG.error("Failed to initialize data in store", (Throwable)e);
        }
        LocalHttpServer httpService = new LocalHttpServer(server);
        this.registerServletContexts(httpService, moonEndpointPath);
    }

    public static CompletableFuture<AAALightyShiroProvider> newInstance(DataBroker dataBroker, ICertificateManager certificateManager, CredentialAuth<PasswordCredentials> credentialAuth, ShiroConfiguration shiroConfiguration, String moonEndpointPath, DatastoreConfig datastoreConfig, String dbUsername, String dbPassword, LightyServerBuilder server, IIDMStore store, PasswordHashService passHashService) {
        CompletableFuture<AAALightyShiroProvider> completableFuture = new CompletableFuture<AAALightyShiroProvider>();
        INSTANCE = new AAALightyShiroProvider(dataBroker, certificateManager, credentialAuth, shiroConfiguration, moonEndpointPath, datastoreConfig, dbUsername, dbPassword, server, store, passHashService);
        completableFuture.complete(INSTANCE);
        return completableFuture;
    }

    public static AAALightyShiroProvider getInstance() {
        return INSTANCE;
    }

    public static IIDMStore getIdmStore() {
        return AAALightyShiroProvider.INSTANCE.iidmStore;
    }

    public static void setIdmStore(IIDMStore store) {
        AAALightyShiroProvider.INSTANCE.iidmStore = store;
    }

    public static TokenStore getTokenStore() {
        return AAALightyShiroProvider.INSTANCE.tokenStore;
    }

    public static TokenAuthenticators getTokenAuthenticators() {
        return AAALightyShiroProvider.INSTANCE.tokenAuthenticators;
    }

    public static AuthenticationManager getAuthenticationManager() {
        return AAALightyShiroProvider.INSTANCE.authenticationManager;
    }

    public static PasswordHashService getPasswordHashService() {
        return AAALightyShiroProvider.INSTANCE.passwordHashService;
    }

    private void initAAAonServer(LightyServerBuilder server, PasswordHashService defaultPasswordHashService) {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        ServletContextHandler mainHandler = new ServletContextHandler((HandlerContainer)contexts, "/auth", true, false);
        IdmLightApplication idmLightApplication = new IdmLightApplication(this.iidmStore, this.claimCache);
        ServletHolder idmLightServlet = new ServletHolder((Servlet)new ServletContainer(ResourceConfig.forApplication((Application)idmLightApplication)));
        idmLightServlet.setInitParameter("jersey.config.server.provider.packages", "org.opendaylight.aaa.impl.provider");
        mainHandler.addServlet(idmLightServlet, "/*");
        server.addContextHandler((Handler)contexts);
        this.handlers.add((Handler)contexts);
        server.addCommonEventListener((EventListener)new ShiroWebEnvironmentLoaderListener(this.shiroConfiguration, this.dataBroker, this.certificateManager, (AuthenticationService)this.authenticationManager, this.tokenAuthenticators, this.tokenStore, defaultPasswordHashService));
        HashMap properties = new HashMap();
        CustomFilterAdapterConfigurationImpl customFilterAdapterConfig = new CustomFilterAdapterConfigurationImpl(properties);
        FilterHolder customFilterAdapter = new FilterHolder((Filter)new CustomFilterAdapter((CustomFilterAdapterConfiguration)customFilterAdapterConfig));
        server.addCommonFilter(customFilterAdapter, "/*");
        FilterHolder shiroFilter = new FilterHolder((Filter)new AAAShiroFilter());
        server.addCommonFilter(shiroFilter, "/*");
        FilterHolder crossOriginFilter = new FilterHolder((Filter)new CrossOriginFilter());
        crossOriginFilter.setInitParameter("allowedMethods", "GET,POST,OPTIONS,DELETE,PUT,HEAD");
        crossOriginFilter.setInitParameter("allowedHeaders", "origin, content-type, accept, authorization, Authorization");
        server.addCommonFilter(crossOriginFilter, "/*");
    }

    public DataBroker getDataBroker() {
        return this.dataBroker;
    }

    public ICertificateManager getCertificateManager() {
        return this.certificateManager;
    }

    public ShiroConfiguration getShiroConfiguration() {
        return this.shiroConfiguration;
    }

    public void close() {
        this.handlers.forEach(handler -> handler.destroy());
    }

    private void registerServletContexts(LocalHttpServer httpService, String moonEndpointPath) {
        LOG.info("attempting registration of AAA moon and auth servlets");
        Preconditions.checkNotNull((Object)httpService, (Object)"httpService cannot be null");
        httpService.registerServlet(moonEndpointPath, (Servlet)new MoonTokenEndpoint(), null);
    }

    private void injectLightyShiroProviderMethodsToOriginalProvider() {
        try {
            CtClass ctClass = ClassPool.getDefault().get("org.opendaylight.aaa.AAAShiroProvider");
            CtConstructor c = CtNewConstructor.make((String)"public AAAShiroProvider(){}", (CtClass)ctClass);
            ctClass.addConstructor(c);
            ctClass.removeMethod(ctClass.getDeclaredMethod("getTokenAuthenticators"));
            CtMethod getTokenAuthenticators = CtNewMethod.make((String)"public static org.opendaylight.aaa.shiro.tokenauthrealm.auth.TokenAuthenticators getTokenAuthenticators() {return io.lighty.aaa.AAALightyShiroProvider.getTokenAuthenticators();}", (CtClass)ctClass);
            ctClass.addMethod(getTokenAuthenticators);
            ctClass.removeMethod(ctClass.getDeclaredMethod("getTokenStore"));
            CtMethod getTokenStore = CtNewMethod.make((String)"public static org.opendaylight.aaa.api.TokenStore getTokenStore() {return io.lighty.aaa.AAALightyShiroProvider.getTokenStore();}", (CtClass)ctClass);
            ctClass.addMethod(getTokenStore);
            ctClass.removeMethod(ctClass.getDeclaredMethod("getAuthenticationService"));
            CtMethod getAuthenticationService = CtNewMethod.make((String)"public static org.opendaylight.aaa.api.AuthenticationService getAuthenticationService() {return io.lighty.aaa.AAALightyShiroProvider.getAuthenticationManager();}", (CtClass)ctClass);
            ctClass.addMethod(getAuthenticationService);
            ctClass.removeMethod(ctClass.getDeclaredMethod("getPasswordHashService"));
            CtMethod getPasswordHashService = CtNewMethod.make((String)"public static org.opendaylight.aaa.api.password.service.PasswordHashService getPasswordHashService() {return io.lighty.aaa.AAALightyShiroProvider.getPasswordHashService();}", (CtClass)ctClass);
            ctClass.addMethod(getPasswordHashService);
            ctClass.removeMethod(ctClass.getDeclaredMethod("getDataBroker"));
            CtMethod getDataBroker = CtNewMethod.make((String)"public org.opendaylight.mdsal.binding.api.DataBroker getDataBroker() {return io.lighty.aaa.AAALightyShiroProvider.getInstance().getDataBroker();}", (CtClass)ctClass);
            ctClass.addMethod(getDataBroker);
            ctClass.removeMethod(ctClass.getDeclaredMethod("getCertificateManager"));
            CtMethod getCertificateManager = CtNewMethod.make((String)"public org.opendaylight.aaa.cert.api.ICertificateManager getCertificateManager() {return io.lighty.aaa.AAALightyShiroProvider.getInstance().getCertificateManager();}", (CtClass)ctClass);
            ctClass.addMethod(getCertificateManager);
            ctClass.removeMethod(ctClass.getDeclaredMethod("getShiroConfiguration"));
            CtMethod getShiroConfiguration = CtNewMethod.make((String)"public org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.ShiroConfiguration getShiroConfiguration() {return io.lighty.aaa.AAALightyShiroProvider.getInstance().getShiroConfiguration();}", (CtClass)ctClass);
            ctClass.addMethod(getShiroConfiguration);
            ctClass.toClass();
        }
        catch (CannotCompileException | NotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

