/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.aaa.encrypt.service.impl;

import java.nio.charset.Charset;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.xml.bind.DatatypeConverter;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AAAEncryptionServiceImpl
implements AAAEncryptionService {
    private static final Logger LOG = LoggerFactory.getLogger(AAAEncryptionServiceImpl.class);
    private final Cipher encryptCipher;
    private final Cipher decryptCipher;

    public AAAEncryptionServiceImpl(Cipher encryptCipher, Cipher decryptCipher) {
        this.encryptCipher = encryptCipher;
        this.decryptCipher = decryptCipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encrypt(String data) {
        if (data != null && data.length() != 0) {
            try {
                Cipher cipher = this.encryptCipher;
                synchronized (cipher) {
                    byte[] cryptobytes = this.encryptCipher.doFinal(data.getBytes(Charset.defaultCharset()));
                    return DatatypeConverter.printBase64Binary((byte[])cryptobytes);
                }
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                LOG.error("Failed to encrypt data.", (Throwable)e);
                return data;
            }
        }
        LOG.warn("data is empty or null.");
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(byte[] data) {
        if (data != null && data.length != 0) {
            try {
                Cipher cipher = this.encryptCipher;
                synchronized (cipher) {
                    return this.encryptCipher.doFinal(data);
                }
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                LOG.error("Failed to encrypt data.", (Throwable)e);
                return data;
            }
        }
        LOG.warn("data is empty or null.");
        return data;
    }

    public String decrypt(String encryptedData) {
        if (encryptedData != null && encryptedData.length() != 0) {
            try {
                byte[] cryptobytes = DatatypeConverter.parseBase64Binary((String)encryptedData);
                byte[] clearbytes = this.decryptCipher.doFinal(cryptobytes);
                return new String(clearbytes, Charset.defaultCharset());
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                LOG.error("Failed to decrypt encoded data", (Throwable)e);
                return encryptedData;
            }
        }
        LOG.warn("encryptedData is empty or null.");
        return encryptedData;
    }

    public byte[] decrypt(byte[] encryptedData) {
        if (encryptedData != null && encryptedData.length != 0) {
            try {
                return this.decryptCipher.doFinal(encryptedData);
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                LOG.error("Failed to decrypt encoded data", (Throwable)e);
                return encryptedData;
            }
        }
        LOG.warn("encryptedData is empty or null.");
        return encryptedData;
    }
}

