/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Ipv6Prefix;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.UnionTypeObject;

public class IpPrefix
implements UnionTypeObject,
Serializable {
    private static final long serialVersionUID = 776725407829840705L;
    public static final List<String> PATTERN_CONSTANTS = ImmutableList.of((Object)"^(?:(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9]))$", (Object)"^(?:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])/(([0-9])|([1-2][0-9])|(3[0-2])))$");
    private static final Pattern[] patterns = CodeHelpers.compilePatterns(PATTERN_CONSTANTS);
    private static final String[] regexes = new String[]{"(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])", "(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])/(([0-9])|([1-2][0-9])|(3[0-2]))"};
    private final Ipv4Prefix _ipv4Prefix;
    private final Ipv6Prefix _ipv6Prefix;

    public IpPrefix(Ipv4Prefix _ipv4Prefix) {
        this._ipv4Prefix = Objects.requireNonNull(_ipv4Prefix);
        this._ipv6Prefix = null;
    }

    public IpPrefix(Ipv6Prefix _ipv6Prefix) {
        this._ipv4Prefix = null;
        this._ipv6Prefix = Objects.requireNonNull(_ipv6Prefix);
    }

    public IpPrefix(IpPrefix source) {
        this._ipv4Prefix = source._ipv4Prefix;
        this._ipv6Prefix = source._ipv6Prefix;
    }

    public String stringValue() {
        if (this._ipv4Prefix != null) {
            return this._ipv4Prefix.getValue().toString();
        }
        if (this._ipv6Prefix != null) {
            return this._ipv6Prefix.getValue().toString();
        }
        throw new IllegalStateException("No value assigned");
    }

    public Ipv4Prefix getIpv4Prefix() {
        return this._ipv4Prefix;
    }

    public Ipv6Prefix getIpv6Prefix() {
        return this._ipv6Prefix;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._ipv4Prefix);
        result = 31 * result + Objects.hashCode(this._ipv6Prefix);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof IpPrefix)) return false;
        IpPrefix other = (IpPrefix)obj;
        if (!Objects.equals(this._ipv4Prefix, other._ipv4Prefix)) return false;
        if (!Objects.equals(this._ipv6Prefix, other._ipv6Prefix)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(IpPrefix.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"ipv4Prefix", (Object)this._ipv4Prefix);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"ipv6Prefix", (Object)this._ipv6Prefix);
        return helper.toString();
    }
}

