/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.host.entries.host.entry;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemDnsStaticConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemDnsStaticState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.host.entries.host.entry.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Ipv4Address;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Ipv6Address;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StateBuilder {
    private Set<String> _alias;
    private String _hostname;
    private Set<Ipv4Address> _ipv4Address;
    private Set<Ipv6Address> _ipv6Address;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    public StateBuilder() {
    }

    public StateBuilder(SystemDnsStaticConfig arg) {
        this._hostname = arg.getHostname();
        this._alias = arg.getAlias();
        this._ipv4Address = arg.getIpv4Address();
        this._ipv6Address = arg.getIpv6Address();
    }

    public StateBuilder(SystemDnsStaticState arg) {
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._alias = base.getAlias();
        this._hostname = base.getHostname();
        this._ipv4Address = base.getIpv4Address();
        this._ipv6Address = base.getIpv6Address();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof SystemDnsStaticState) {
            castArg = (SystemDnsStaticState)arg;
            isValidArg = true;
        }
        if (arg instanceof SystemDnsStaticConfig) {
            castArg = (SystemDnsStaticConfig)arg;
            this._hostname = castArg.getHostname();
            this._alias = castArg.getAlias();
            this._ipv4Address = castArg.getIpv4Address();
            this._ipv6Address = castArg.getIpv6Address();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SystemDnsStaticState, SystemDnsStaticConfig]");
    }

    public static @NonNull State empty() {
        return LazyEmpty.INSTANCE;
    }

    public Set<String> getAlias() {
        return this._alias;
    }

    public String getHostname() {
        return this._hostname;
    }

    public Set<Ipv4Address> getIpv4Address() {
        return this._ipv4Address;
    }

    public Set<Ipv6Address> getIpv6Address() {
        return this._ipv6Address;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setAlias(Set<String> values) {
        this._alias = values;
        return this;
    }

    public StateBuilder setHostname(String value) {
        this._hostname = value;
        return this;
    }

    public StateBuilder setIpv4Address(Set<Ipv4Address> values) {
        this._ipv4Address = values;
        return this;
    }

    public StateBuilder setIpv6Address(Set<Ipv6Address> values) {
        this._ipv6Address = values;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull State INSTANCE = new StateBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final Set<String> _alias;
        private final String _hostname;
        private final Set<Ipv4Address> _ipv4Address;
        private final Set<Ipv6Address> _ipv6Address;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._alias = base.getAlias();
            this._hostname = base.getHostname();
            this._ipv4Address = base.getIpv4Address();
            this._ipv6Address = base.getIpv6Address();
        }

        @Override
        public Set<String> getAlias() {
            return this._alias;
        }

        @Override
        public String getHostname() {
            return this._hostname;
        }

        @Override
        public Set<Ipv4Address> getIpv4Address() {
            return this._ipv4Address;
        }

        @Override
        public Set<Ipv6Address> getIpv6Address() {
            return this._ipv6Address;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

