/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.host.entries;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.host.entries.HostEntry;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.host.entries.HostEntryKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.host.entries.host.entry.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.host.entries.host.entry.ConfigBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.host.entries.host.entry.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.host.entries.host.entry.StateBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class HostEntryBuilder {
    private Config _config;
    private String _hostname;
    private State _state;
    private HostEntryKey key;
    Map<Class<? extends Augmentation<HostEntry>>, Augmentation<HostEntry>> augmentation = Map.of();

    public HostEntryBuilder() {
    }

    public HostEntryBuilder(HostEntry base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<HostEntry>>, Augmentation<HostEntry>>(aug);
        }
        this.key = base.key();
        this._hostname = base.getHostname();
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public HostEntryKey key() {
        return this.key;
    }

    public Config getConfig() {
        return this._config;
    }

    public String getHostname() {
        return this._hostname;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<HostEntry>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public HostEntryBuilder withKey(HostEntryKey key) {
        this.key = key;
        return this;
    }

    public HostEntryBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public HostEntryBuilder setHostname(String value) {
        this._hostname = value;
        return this;
    }

    public HostEntryBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public HostEntryBuilder addAugmentation(Augmentation<HostEntry> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<HostEntry>>, Augmentation<HostEntry>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public HostEntryBuilder removeAugmentation(Class<? extends Augmentation<HostEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull HostEntry build() {
        return new HostEntryImpl(this);
    }

    private static final class HostEntryImpl
    extends AbstractAugmentable<HostEntry>
    implements HostEntry {
        private final Config _config;
        private final String _hostname;
        private final State _state;
        private final HostEntryKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        HostEntryImpl(HostEntryBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new HostEntryKey(base.getHostname());
            this._hostname = this.key.getHostname();
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public HostEntryKey key() {
            return this.key;
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public String getHostname() {
            return this._hostname;
        }

        @Override
        public State getState() {
            return this._state;
        }

        @Override
        public Config nonnullConfig() {
            return Objects.requireNonNullElse(this.getConfig(), ConfigBuilder.empty());
        }

        @Override
        public State nonnullState() {
            return Objects.requireNonNullElse(this.getState(), StateBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = HostEntry.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return HostEntry.bindingEquals(this, obj);
        }

        public String toString() {
            return HostEntry.bindingToString(this);
        }
    }
}

