/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Host;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.system.rev200413.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

public interface SystemNtpServerConfig
extends DataObject {
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("system-ntp-server-config");

    public Class<? extends SystemNtpServerConfig> implementedInterface();

    public Host getAddress();

    default public @NonNull Host requireAddress() {
        return (Host)CodeHelpers.require((Object)this.getAddress(), (String)"address");
    }

    public PortNumber getPort();

    default public @NonNull PortNumber requirePort() {
        return (PortNumber)CodeHelpers.require((Object)this.getPort(), (String)"port");
    }

    public Uint8 getVersion();

    default public @NonNull Uint8 requireVersion() {
        return (Uint8)CodeHelpers.require((Object)this.getVersion(), (String)"version");
    }

    public AssociationType getAssociationType();

    default public @NonNull AssociationType requireAssociationType() {
        return (AssociationType)((Object)CodeHelpers.require((Object)((Object)this.getAssociationType()), (String)"associationtype"));
    }

    public Boolean getIburst();

    default public @NonNull Boolean requireIburst() {
        return (Boolean)CodeHelpers.require((Object)this.getIburst(), (String)"iburst");
    }

    public Boolean getPrefer();

    default public @NonNull Boolean requirePrefer() {
        return (Boolean)CodeHelpers.require((Object)this.getPrefer(), (String)"prefer");
    }

    public static enum AssociationType implements EnumTypeObject
    {
        SERVER(0, "SERVER"),
        PEER(1, "PEER"),
        POOL(2, "POOL");

        private final @NonNull String name;
        private final int value;

        private AssociationType(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static @Nullable AssociationType forName(String name) {
            return switch (name) {
                case "SERVER" -> SERVER;
                case "PEER" -> PEER;
                case "POOL" -> POOL;
                default -> null;
            };
        }

        public static @Nullable AssociationType forValue(int intValue) {
            return switch (intValue) {
                case 0 -> SERVER;
                case 1 -> PEER;
                case 2 -> POOL;
                default -> null;
            };
        }

        public static @NonNull AssociationType ofName(String name) {
            return (AssociationType)CodeHelpers.checkEnum((EnumTypeObject)AssociationType.forName(name), (String)name);
        }

        public static @NonNull AssociationType ofValue(int intValue) {
            return (AssociationType)CodeHelpers.checkEnum((EnumTypeObject)AssociationType.forValue(intValue), (int)intValue);
        }
    }
}

