/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.connection;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowConnectionsConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.connection.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.AuxiliaryId;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.Transport;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class ConfigBuilder {
    private IpAddress _address;
    private AuxiliaryId _auxId;
    private String _certificateId;
    private PortNumber _port;
    private Uint8 _priority;
    private String _sourceInterface;
    private Transport _transport;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    public ConfigBuilder() {
    }

    public ConfigBuilder(OpenflowConnectionsConfig arg) {
        this._auxId = arg.getAuxId();
        this._priority = arg.getPriority();
        this._address = arg.getAddress();
        this._port = arg.getPort();
        this._transport = arg.getTransport();
        this._certificateId = arg.getCertificateId();
        this._sourceInterface = arg.getSourceInterface();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._address = base.getAddress();
        this._auxId = base.getAuxId();
        this._certificateId = base.getCertificateId();
        this._port = base.getPort();
        this._priority = base.getPriority();
        this._sourceInterface = base.getSourceInterface();
        this._transport = base.getTransport();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OpenflowConnectionsConfig) {
            OpenflowConnectionsConfig castArg = (OpenflowConnectionsConfig)arg;
            this._auxId = castArg.getAuxId();
            this._priority = castArg.getPriority();
            this._address = castArg.getAddress();
            this._port = castArg.getPort();
            this._transport = castArg.getTransport();
            this._certificateId = castArg.getCertificateId();
            this._sourceInterface = castArg.getSourceInterface();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[OpenflowConnectionsConfig]");
    }

    public static @NonNull Config empty() {
        return LazyEmpty.INSTANCE;
    }

    public IpAddress getAddress() {
        return this._address;
    }

    public AuxiliaryId getAuxId() {
        return this._auxId;
    }

    public String getCertificateId() {
        return this._certificateId;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public Uint8 getPriority() {
        return this._priority;
    }

    public String getSourceInterface() {
        return this._sourceInterface;
    }

    public Transport getTransport() {
        return this._transport;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setAddress(IpAddress value) {
        this._address = value;
        return this;
    }

    public ConfigBuilder setAuxId(AuxiliaryId value) {
        this._auxId = value;
        return this;
    }

    public ConfigBuilder setCertificateId(String value) {
        this._certificateId = value;
        return this;
    }

    public ConfigBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public ConfigBuilder setPriority(Uint8 value) {
        this._priority = value;
        return this;
    }

    public ConfigBuilder setSourceInterface(String value) {
        this._sourceInterface = value;
        return this;
    }

    public ConfigBuilder setTransport(Transport value) {
        this._transport = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Config INSTANCE = new ConfigBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final IpAddress _address;
        private final AuxiliaryId _auxId;
        private final String _certificateId;
        private final PortNumber _port;
        private final Uint8 _priority;
        private final String _sourceInterface;
        private final Transport _transport;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._address = base.getAddress();
            this._auxId = base.getAuxId();
            this._certificateId = base.getCertificateId();
            this._port = base.getPort();
            this._priority = base.getPriority();
            this._sourceInterface = base.getSourceInterface();
            this._transport = base.getTransport();
        }

        @Override
        public IpAddress getAddress() {
            return this._address;
        }

        @Override
        public AuxiliaryId getAuxId() {
            return this._auxId;
        }

        @Override
        public String getCertificateId() {
            return this._certificateId;
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        @Override
        public Uint8 getPriority() {
            return this._priority;
        }

        @Override
        public String getSourceInterface() {
            return this._sourceInterface;
        }

        @Override
        public Transport getTransport() {
            return this._transport;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

