/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.license.rev200422.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.UnionTypeObject;
import org.opendaylight.yangtools.yang.common.QName;

public interface LicenseConfig
extends DataObject {
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("license-config");

    public Class<? extends LicenseConfig> implementedInterface();

    public String getLicenseId();

    default public @NonNull String requireLicenseId() {
        return (String)CodeHelpers.require((Object)this.getLicenseId(), (String)"licenseid");
    }

    public LicenseData getLicenseData();

    default public @NonNull LicenseData requireLicenseData() {
        return (LicenseData)CodeHelpers.require((Object)this.getLicenseData(), (String)"licensedata");
    }

    public Boolean getActive();

    default public @NonNull Boolean requireActive() {
        return (Boolean)CodeHelpers.require((Object)this.getActive(), (String)"active");
    }

    public static final class LicenseData
    implements UnionTypeObject,
    Serializable {
        private static final long serialVersionUID = 8620642263735776498L;
        private final byte[] _binary;
        private final String _string;

        public LicenseData(byte[] _binary) {
            this._binary = Objects.requireNonNull(_binary);
            this._string = null;
        }

        public LicenseData(String _string) {
            this._binary = null;
            this._string = Objects.requireNonNull(_string);
        }

        public LicenseData(LicenseData source) {
            this._binary = source._binary == null ? null : (byte[])source._binary.clone();
            this._string = source._string;
        }

        public String stringValue() {
            if (this._binary != null) {
                return new String(this._binary);
            }
            if (this._string != null) {
                return this._string;
            }
            throw new IllegalStateException("No value assigned");
        }

        public byte[] getBinary() {
            return this._binary == null ? null : (byte[])this._binary.clone();
        }

        public String getString() {
            return this._string;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this._binary);
            result = 31 * result + Objects.hashCode(this._string);
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof LicenseData)) return false;
            LicenseData other = (LicenseData)obj;
            if (!Arrays.equals(this._binary, other._binary)) return false;
            if (!Objects.equals(this._string, other._string)) return false;
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(LicenseData.class);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"binary", (byte[])this._binary);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"string", (Object)this._string);
            return helper.toString();
        }
    }
}

