/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.ethernet;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ETHERNETSPEED;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet._interface.state.Counters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet._interface.state.CountersBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.ethernet.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.MacAddress;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StateBuilder {
    private Boolean _autoNegotiate;
    private Counters _counters;
    private EthernetInterfaceConfig.DuplexMode _duplexMode;
    private Boolean _enableFlowControl;
    private MacAddress _hwMacAddress;
    private MacAddress _macAddress;
    private EthernetInterfaceState.NegotiatedDuplexMode _negotiatedDuplexMode;
    private ETHERNETSPEED _negotiatedPortSpeed;
    private ETHERNETSPEED _portSpeed;
    private Boolean _standaloneLinkTraining;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    public StateBuilder() {
    }

    public StateBuilder(EthernetInterfaceConfig arg) {
        this._macAddress = arg.getMacAddress();
        this._autoNegotiate = arg.getAutoNegotiate();
        this._standaloneLinkTraining = arg.getStandaloneLinkTraining();
        this._duplexMode = arg.getDuplexMode();
        this._portSpeed = arg.getPortSpeed();
        this._enableFlowControl = arg.getEnableFlowControl();
    }

    public StateBuilder(EthernetInterfaceState arg) {
        this._hwMacAddress = arg.getHwMacAddress();
        this._negotiatedDuplexMode = arg.getNegotiatedDuplexMode();
        this._negotiatedPortSpeed = arg.getNegotiatedPortSpeed();
        this._counters = arg.getCounters();
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._autoNegotiate = base.getAutoNegotiate();
        this._counters = base.getCounters();
        this._duplexMode = base.getDuplexMode();
        this._enableFlowControl = base.getEnableFlowControl();
        this._hwMacAddress = base.getHwMacAddress();
        this._macAddress = base.getMacAddress();
        this._negotiatedDuplexMode = base.getNegotiatedDuplexMode();
        this._negotiatedPortSpeed = base.getNegotiatedPortSpeed();
        this._portSpeed = base.getPortSpeed();
        this._standaloneLinkTraining = base.getStandaloneLinkTraining();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof EthernetInterfaceConfig) {
            castArg = (EthernetInterfaceConfig)arg;
            this._macAddress = castArg.getMacAddress();
            this._autoNegotiate = castArg.getAutoNegotiate();
            this._standaloneLinkTraining = castArg.getStandaloneLinkTraining();
            this._duplexMode = castArg.getDuplexMode();
            this._portSpeed = castArg.getPortSpeed();
            this._enableFlowControl = castArg.getEnableFlowControl();
            isValidArg = true;
        }
        if (arg instanceof EthernetInterfaceState) {
            castArg = (EthernetInterfaceState)arg;
            this._hwMacAddress = castArg.getHwMacAddress();
            this._negotiatedDuplexMode = castArg.getNegotiatedDuplexMode();
            this._negotiatedPortSpeed = castArg.getNegotiatedPortSpeed();
            this._counters = castArg.getCounters();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[EthernetInterfaceConfig, EthernetInterfaceState]");
    }

    public static @NonNull State empty() {
        return LazyEmpty.INSTANCE;
    }

    public Boolean getAutoNegotiate() {
        return this._autoNegotiate;
    }

    public Counters getCounters() {
        return this._counters;
    }

    public EthernetInterfaceConfig.DuplexMode getDuplexMode() {
        return this._duplexMode;
    }

    public Boolean getEnableFlowControl() {
        return this._enableFlowControl;
    }

    public MacAddress getHwMacAddress() {
        return this._hwMacAddress;
    }

    public MacAddress getMacAddress() {
        return this._macAddress;
    }

    public EthernetInterfaceState.NegotiatedDuplexMode getNegotiatedDuplexMode() {
        return this._negotiatedDuplexMode;
    }

    public ETHERNETSPEED getNegotiatedPortSpeed() {
        return this._negotiatedPortSpeed;
    }

    public ETHERNETSPEED getPortSpeed() {
        return this._portSpeed;
    }

    public Boolean getStandaloneLinkTraining() {
        return this._standaloneLinkTraining;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setAutoNegotiate(Boolean value) {
        this._autoNegotiate = value;
        return this;
    }

    public StateBuilder setCounters(Counters value) {
        this._counters = value;
        return this;
    }

    public StateBuilder setDuplexMode(EthernetInterfaceConfig.DuplexMode value) {
        this._duplexMode = value;
        return this;
    }

    public StateBuilder setEnableFlowControl(Boolean value) {
        this._enableFlowControl = value;
        return this;
    }

    public StateBuilder setHwMacAddress(MacAddress value) {
        this._hwMacAddress = value;
        return this;
    }

    public StateBuilder setMacAddress(MacAddress value) {
        this._macAddress = value;
        return this;
    }

    public StateBuilder setNegotiatedDuplexMode(EthernetInterfaceState.NegotiatedDuplexMode value) {
        this._negotiatedDuplexMode = value;
        return this;
    }

    public StateBuilder setNegotiatedPortSpeed(ETHERNETSPEED value) {
        this._negotiatedPortSpeed = value;
        return this;
    }

    public StateBuilder setPortSpeed(ETHERNETSPEED value) {
        this._portSpeed = value;
        return this;
    }

    public StateBuilder setStandaloneLinkTraining(Boolean value) {
        this._standaloneLinkTraining = value;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull State INSTANCE = new StateBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final Boolean _autoNegotiate;
        private final Counters _counters;
        private final EthernetInterfaceConfig.DuplexMode _duplexMode;
        private final Boolean _enableFlowControl;
        private final MacAddress _hwMacAddress;
        private final MacAddress _macAddress;
        private final EthernetInterfaceState.NegotiatedDuplexMode _negotiatedDuplexMode;
        private final ETHERNETSPEED _negotiatedPortSpeed;
        private final ETHERNETSPEED _portSpeed;
        private final Boolean _standaloneLinkTraining;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._autoNegotiate = base.getAutoNegotiate();
            this._counters = base.getCounters();
            this._duplexMode = base.getDuplexMode();
            this._enableFlowControl = base.getEnableFlowControl();
            this._hwMacAddress = base.getHwMacAddress();
            this._macAddress = base.getMacAddress();
            this._negotiatedDuplexMode = base.getNegotiatedDuplexMode();
            this._negotiatedPortSpeed = base.getNegotiatedPortSpeed();
            this._portSpeed = base.getPortSpeed();
            this._standaloneLinkTraining = base.getStandaloneLinkTraining();
        }

        @Override
        public Boolean getAutoNegotiate() {
            return this._autoNegotiate;
        }

        @Override
        public Counters getCounters() {
            return this._counters;
        }

        @Override
        public EthernetInterfaceConfig.DuplexMode getDuplexMode() {
            return this._duplexMode;
        }

        @Override
        public Boolean getEnableFlowControl() {
            return this._enableFlowControl;
        }

        @Override
        public MacAddress getHwMacAddress() {
            return this._hwMacAddress;
        }

        @Override
        public MacAddress getMacAddress() {
            return this._macAddress;
        }

        @Override
        public EthernetInterfaceState.NegotiatedDuplexMode getNegotiatedDuplexMode() {
            return this._negotiatedDuplexMode;
        }

        @Override
        public ETHERNETSPEED getNegotiatedPortSpeed() {
            return this._negotiatedPortSpeed;
        }

        @Override
        public ETHERNETSPEED getPortSpeed() {
            return this._portSpeed;
        }

        @Override
        public Boolean getStandaloneLinkTraining() {
            return this._standaloneLinkTraining;
        }

        @Override
        public Counters nonnullCounters() {
            return Objects.requireNonNullElse(this.getCounters(), CountersBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

