package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.vlan.types.rev200630.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * A wildcard that matches any of the generally used TPID values for singly- or 
 * multiply-tagged VLANs. Equivalent to matching any of TPID_0X8100, TPID_0X88A8, 
 * TPID_0X9100 and TPID_0x9200. This value is only applicable where the TPID of a 
 * packet is being matched.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan-types</b>
 * <pre>
 * identity TPID_ANY {
 *   base TPID_TYPES;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface TPIDANY
    extends
    TPIDTYPES
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("TPID_ANY");
    /**
     * Singleton value representing the {@link TPIDANY} identity.
     */
    public static final @NonNull TPIDANY VALUE = new TPIDANY() {
        @Override
        public Class<TPIDANY> implementedInterface() {
            return TPIDANY.class;
        }
    
        @Override
        public int hashCode() {
            return TPIDANY.class.hashCode();
        }
    
        @Override
        public boolean equals(final Object obj) {
            return obj == this || obj instanceof TPIDANY other
                && TPIDANY.class.equals(other.implementedInterface());
        }
    
        @Override
        public String toString() {
            return MoreObjects.toStringHelper("TPIDANY").add("qname", QNAME).toString();
        }
    };

    @Override
    Class<? extends TPIDANY> implementedInterface();

}

