package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;

/**
 * This class represents the key of {@link Vlan} class.
 *
 * @see Vlan
 *
 */
@Generated("mdsal-binding-generator")
public class VlanKey
 implements Key<Vlan> {
    @java.io.Serial
    private static final long serialVersionUID = -6999820048426707562L;
    private final VlanId _vlanId;


    /**
     * Constructs an instance.
     *
     * @param _vlanId the entity vlanId
     * @throws NullPointerException if any of the arguments are null
     */
    public VlanKey(@NonNull VlanId _vlanId) {
        this._vlanId = CodeHelpers.requireKeyProp(_vlanId, "vlanId");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public VlanKey(VlanKey source) {
        this._vlanId = source._vlanId;
    }


    /**
     * Return vlanId, guaranteed to be non-null.
     *
     * @return {@code VlanId} vlanId, guaranteed to be non-null.
     */
    public @NonNull VlanId getVlanId() {
        return _vlanId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_vlanId);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof VlanKey other
            && Objects.equals(_vlanId, other._vlanId);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(VlanKey.class);
        CodeHelpers.appendValue(helper, "vlanId", _vlanId);
        return helper.toString();
    }
}

