package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.Vlans;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.vlan.rev190416.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for VLAN configuration
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-top {
 *   container vlans {
 *     list vlan {
 *       key vlan-id;
 *       leaf vlan-id {
 *         type leafref {
 *           path ../config/vlan-id;
 *         }
 *       }
 *       container config {
 *         uses vlan-config;
 *       }
 *       container state {
 *         config false;
 *         uses vlan-config;
 *         uses vlan-state;
 *       }
 *       uses vlan-members-state;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("vlan-top");

    @Override
    Class<? extends VlanTop> implementedInterface();
    
    /**
     * Return vlans, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Container for VLAN configuration and state variables
     *     </code>
     * </pre>
     *
     * @return {@code Vlans} vlans, or {@code null} if it is not present.
     *
     */
    Vlans getVlans();
    
    /**
     * Return vlans, or an empty instance if it is not present.
     *
     * @return {@code Vlans} vlans, or an empty instance if it is not present.
     *
     */
    @NonNull Vlans nonnullVlans();

}

