package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.routed.top.RoutedVlan;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.vlan.rev190416.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for routed vlan logical interfaces
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-routed-top {
 *   container routed-vlan {
 *     container config {
 *       uses vlan-routed-config;
 *     }
 *     container state {
 *       config false;
 *       uses vlan-routed-config;
 *       uses vlan-routed-state;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanRoutedTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("vlan-routed-top");

    @Override
    Class<? extends VlanRoutedTop> implementedInterface();
    
    /**
     * Return routedVlan, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for routed vlan interfaces. These logical interfaces are
     *         also known as SVI (switched virtual interface), IRB (integrated routing and
     *         bridging), RVI (routed VLAN interface)
     *     </code>
     * </pre>
     *
     * @return {@code RoutedVlan} routedVlan, or {@code null} if it is not present.
     *
     */
    RoutedVlan getRoutedVlan();
    
    /**
     * Return routedVlan, or an empty instance if it is not present.
     *
     * @return {@code RoutedVlan} routedVlan, or an empty instance if it is not present.
     *
     */
    @NonNull RoutedVlan nonnullRoutedVlan();

}

