package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.vlan.rev190416.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Specifies single-tagged packets with a range of VLAN identifiers.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-logical-single-tagged-range-config {
 *   leaf low-vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 *   leaf high-vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanLogicalSingleTaggedRangeConfig
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("vlan-logical-single-tagged-range-config");

    @Override
    Class<? extends VlanLogicalSingleTaggedRangeConfig> implementedInterface();
    
    /**
     * Return lowVlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The low-value VLAN identifier in a range for single-tagged packets. The range is
     *         matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} lowVlanId, or {@code null} if it is not present.
     *
     */
    VlanId getLowVlanId();
    
    /**
     * Return lowVlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The low-value VLAN identifier in a range for single-tagged packets. The range is
     *         matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} lowVlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if lowVlanId is not present
     *
     */
    default @NonNull VlanId requireLowVlanId() {
        return CodeHelpers.require(getLowVlanId(), "lowvlanid");
    }
    
    /**
     * Return highVlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The high-value VLAN identifier in a range for single-tagged packets. The range
     *         is matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} highVlanId, or {@code null} if it is not present.
     *
     */
    VlanId getHighVlanId();
    
    /**
     * Return highVlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The high-value VLAN identifier in a range for single-tagged packets. The range
     *         is matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} highVlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if highVlanId is not present
     *
     */
    default @NonNull VlanId requireHighVlanId() {
        return CodeHelpers.require(getHighVlanId(), "highvlanid");
    }

}

