package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.TPIDTYPES;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanStackAction;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.vlan.rev190416.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration for ingress VLAN stack behaviors for packets that arrive on this 
 * subinterface.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-logical-ingress-mapping-config {
 *   leaf vlan-stack-action {
 *     type oc-vlan-types:vlan-stack-action;
 *   }
 *   leaf vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 *   leaf tpid {
 *     type identityref {
 *       base TPID_TYPES;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanLogicalIngressMappingConfig
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("vlan-logical-ingress-mapping-config");

    @Override
    Class<? extends VlanLogicalIngressMappingConfig> implementedInterface();
    
    /**
     * Return vlanStackAction, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The action to take on the VLAN stack of a packet. This is optionally used in
     *         conjunction with adjacent leaves to override the values of the action.
     *     </code>
     * </pre>
     *
     * @return {@code VlanStackAction} vlanStackAction, or {@code null} if it is not present.
     *
     */
    VlanStackAction getVlanStackAction();
    
    /**
     * Return vlanStackAction, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The action to take on the VLAN stack of a packet. This is optionally used in
     *         conjunction with adjacent leaves to override the values of the action.
     *     </code>
     * </pre>
     *
     * @return {@code VlanStackAction} vlanStackAction, guaranteed to be non-null.
     * @throws NoSuchElementException if vlanStackAction is not present
     *
     */
    default @NonNull VlanStackAction requireVlanStackAction() {
        return CodeHelpers.require(getVlanStackAction(), "vlanstackaction");
    }
    
    /**
     * Return vlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Optionally specifies a fixed VLAN identifier that is used by the action
     *         configured in 'vlan-stack-action'. For example, if the action is 'PUSH' then
     *         this VLAN identifier is added to the the stack. This value must be non-zero if
     *         the 'vlan-stack-action' is one of 'PUSH' or 'SWAP'.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} vlanId, or {@code null} if it is not present.
     *
     */
    VlanId getVlanId();
    
    /**
     * Return vlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Optionally specifies a fixed VLAN identifier that is used by the action
     *         configured in 'vlan-stack-action'. For example, if the action is 'PUSH' then
     *         this VLAN identifier is added to the the stack. This value must be non-zero if
     *         the 'vlan-stack-action' is one of 'PUSH' or 'SWAP'.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} vlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if vlanId is not present
     *
     */
    default @NonNull VlanId requireVlanId() {
        return CodeHelpers.require(getVlanId(), "vlanid");
    }
    
    /**
     * Return tpid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Optionally override the tag protocol identifier field (TPID) that is used by the
     *         action configured by 'vlan-stack-action' when modifying the VLAN stack.
     *     </code>
     * </pre>
     *
     * @return {@code TPIDTYPES} tpid, or {@code null} if it is not present.
     *
     */
    TPIDTYPES getTpid();
    
    /**
     * Return tpid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Optionally override the tag protocol identifier field (TPID) that is used by the
     *         action configured by 'vlan-stack-action' when modifying the VLAN stack.
     *     </code>
     * </pre>
     *
     * @return {@code TPIDTYPES} tpid, guaranteed to be non-null.
     * @throws NoSuchElementException if tpid is not present
     *
     */
    default @NonNull TPIDTYPES requireTpid() {
        return CodeHelpers.require(getTpid(), "tpid");
    }

}

