package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.vlan.rev190416.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Specifies double-tagged packets with an inner exact and outer list of VLAN 
 * identifiers.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-logical-double-tagged-outer-list-config {
 *   leaf inner-vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 *   leaf-list outer-vlan-ids {
 *     type oc-vlan-types:vlan-id;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanLogicalDoubleTaggedOuterListConfig
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("vlan-logical-double-tagged-outer-list-config");

    @Override
    Class<? extends VlanLogicalDoubleTaggedOuterListConfig> implementedInterface();
    
    /**
     * Return innerVlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Inner VLAN identifier for double-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} innerVlanId, or {@code null} if it is not present.
     *
     */
    VlanId getInnerVlanId();
    
    /**
     * Return innerVlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Inner VLAN identifier for double-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} innerVlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if innerVlanId is not present
     *
     */
    default @NonNull VlanId requireInnerVlanId() {
        return CodeHelpers.require(getInnerVlanId(), "innervlanid");
    }
    
    /**
     * Return outerVlanIds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Outer VLAN identifiers for double-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code Set<VlanId>} outerVlanIds, or {@code null} if it is not present.
     *
     */
    @Nullable Set<VlanId> getOuterVlanIds();
    
    /**
     * Return outerVlanIds, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Outer VLAN identifiers for double-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code Set<VlanId>} outerVlanIds, guaranteed to be non-null.
     * @throws NoSuchElementException if outerVlanIds is not present
     *
     */
    default @NonNull Set<VlanId> requireOuterVlanIds() {
        return CodeHelpers.require(getOuterVlanIds(), "outervlanids");
    }

}

