package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.QinqId;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.vlan.rev190416.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.UnionTypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * VLAN related configuration that is part of subinterface (logical interface) 
 * configuration. These are generally L3 VLANs with an id that is local or L2 
 * attached with a wire transport service, such as a local cross-connect or an 
 * pseudo-wire. For ingress packets this VLAN configuration is used to match 
 * packets with an interface; for egress packets, the 'single-tagged' and 
 * 'double-tagged' containers may be used to specify the VLAN identifiers that are 
 * added to packets as they leave the system.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-logical-config {
 *   leaf vlan-id {
 *     type union {
 *       type oc-vlan-types:vlan-id;
 *       type oc-vlan-types:qinq-id;
 *     }
 *     status deprecated;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanLogicalConfig
    extends
    DataObject
{

    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
     * <pre>
     * leaf vlan-id {
     *   type union {
     *     type oc-vlan-types:vlan-id;
     *     type oc-vlan-types:qinq-id;
     *   }
     *   status deprecated;
     * }
     * </pre>
     *
     */
    @Deprecated
    public static final class VlanId
     implements UnionTypeObject, Serializable {
        @java.io.Serial
        private static final long serialVersionUID = -761987435180262101L;
        public static final List<String> PATTERN_CONSTANTS = ImmutableList.of("^(?:\\^(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.((409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])|\\*)\\$)$");
        private static final Pattern patterns = Pattern.compile(PATTERN_CONSTANTS.get(0));
        private static final String regexes = "^(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.((409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])|\\*)$";
        private final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId _vlanId;
        private final QinqId _qinqId;
    
    
        public VlanId(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId _vlanId) {
            this._vlanId = Objects.requireNonNull(_vlanId);
            this._qinqId = null;
        }
        
        public VlanId(QinqId _qinqId) {
            this._vlanId = null;
            this._qinqId = Objects.requireNonNull(_qinqId);
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public VlanId(VlanId source) {
            this._vlanId = source._vlanId;
            this._qinqId = source._qinqId;
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_vlanId != null) {
                return _vlanId.getValue().toString();
            }
            if (_qinqId != null) {
                return _qinqId.getValue().toString();
            }
            throw new IllegalStateException("No value assigned");
        }
    
    
        public org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId getVlanId() {
            return _vlanId;
        }
        
        public QinqId getQinqId() {
            return _qinqId;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_vlanId);
            result = prime * result + Objects.hashCode(_qinqId);
            return result;
        }
    
        @Override
        public final boolean equals(Object obj) {
            return this == obj || obj instanceof VlanId other
                && Objects.equals(_vlanId, other._vlanId)        
                && Objects.equals(_qinqId, other._qinqId);
        }
    
        @Override
        public String toString() {
            final var helper = MoreObjects.toStringHelper(VlanId.class);
            CodeHelpers.appendValue(helper, "vlanId", _vlanId);
            CodeHelpers.appendValue(helper, "qinqId", _qinqId);
            return helper.toString();
        }
    }
    


    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("vlan-logical-config");

    @Override
    Class<? extends VlanLogicalConfig> implementedInterface();
    
    /**
     * Return vlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         VLAN id for the subinterface -- specified inline for the case of a local VLAN.
     *         The id is scoped to the subinterface, and could be repeated on different
     *         subinterfaces. Deprecation note: See adjacent elements in the 'vlan' container
     *         for making more expressive VLAN matches.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} vlanId, or {@code null} if it is not present.
     *
     */
    @Deprecated
    VlanId getVlanId();
    
    /**
     * Return vlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         VLAN id for the subinterface -- specified inline for the case of a local VLAN.
     *         The id is scoped to the subinterface, and could be repeated on different
     *         subinterfaces. Deprecation note: See adjacent elements in the 'vlan' container
     *         for making more expressive VLAN matches.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} vlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if vlanId is not present
     *
     */
    default @NonNull VlanId requireVlanId() {
        return CodeHelpers.require(getVlanId(), "vlanid");
    }

}

