package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.switched.top.SwitchedVlan;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Aggregation1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Aggregation1 createAggregation1(int fooXyzzy, int barBaz) {
 *         return new Aggregation1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Aggregation1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Aggregation1
 *
 */
@Generated("mdsal-binding-generator")
public class Aggregation1Builder {

    private SwitchedVlan _switchedVlan;



    /**
     * Construct an empty builder.
     */
    public Aggregation1Builder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link VlanSwitchedTop}.
     *
     * @param arg VlanSwitchedTop from which the builder should be initialized
     */
    public Aggregation1Builder(VlanSwitchedTop arg) {
        this._switchedVlan = arg.getSwitchedVlan();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Aggregation1}.
     *
     * @param base Aggregation1 from which the builder should be initialized
     */
    public Aggregation1Builder(Aggregation1 base) {
        this._switchedVlan = base.getSwitchedVlan();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link VlanSwitchedTop}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanSwitchedTop castArg) {
            this._switchedVlan = castArg.getSwitchedVlan();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[VlanSwitchedTop]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Aggregation1#getSwitchedVlan()}.
     *
     * @return current value
     */
    public SwitchedVlan getSwitchedVlan() {
        return _switchedVlan;
    }

    
    /**
     * Set the property corresponding to {@link Aggregation1#getSwitchedVlan()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Aggregation1Builder setSwitchedVlan(final SwitchedVlan value) {
        this._switchedVlan = value;
        return this;
    }
    

    /**
     * A new {@link Aggregation1} instance.
     *
     * @return A new {@link Aggregation1} instance.
     */
    public @NonNull Aggregation1 build() {
        return new Aggregation1Impl(this);
    }

    private static final class Aggregation1Impl
        implements Aggregation1 {
    
        private final SwitchedVlan _switchedVlan;
    
        Aggregation1Impl(Aggregation1Builder base) {
            this._switchedVlan = base.getSwitchedVlan();
        }
    
        @Override
        public SwitchedVlan getSwitchedVlan() {
            return _switchedVlan;
        }
    
        @Override
        public SwitchedVlan nonnullSwitchedVlan() {
            return Objects.requireNonNullElse(getSwitchedVlan(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.switched.top.SwitchedVlanBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Aggregation1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Aggregation1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Aggregation1.bindingToString(this);
        }
    }
}
