package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-yang-types</b>
 * <pre>
 * typedef counter32 {
 *   type uint32;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public class Counter32
 implements ScalarTypeObject<Uint32>, Serializable {
    @java.io.Serial
    private static final long serialVersionUID = -3046049553917040756L;
    private final Uint32 _value;

    private static void check_valueRange(final long value) {
    }

    @ConstructorParameters("value")
    public Counter32(Uint32 _value) {
        if (_value != null) {
            check_valueRange(_value.longValue());
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public Counter32(Counter32 source) {
        this._value = source._value;
    }

    public static Counter32 getDefaultInstance(final String defaultValue) {
        return new Counter32(Uint32.valueOf(defaultValue));
    }

    @Override
    public Uint32 getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof Counter32 other
            && Objects.equals(_value, other._value);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(Counter32.class);
        CodeHelpers.appendValue(helper, "value", _value);
        return helper.toString();
    }
}

