package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.system.terminal.rev181121.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for telnet server
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-terminal</b>
 * <pre>
 * grouping system-telnet-server-config {
 *   leaf enable {
 *     type boolean;
 *     default false;
 *   }
 *   uses system-terminal-common-config;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemTelnetServerConfig
    extends
    DataObject,
    SystemTerminalCommonConfig
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("system-telnet-server-config");

    @Override
    Class<? extends SystemTelnetServerConfig> implementedInterface();
    
    /**
     * Return enable, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enables the telnet server. Telnet is disabled by default
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enable, or {@code null} if it is not present.
     *
     */
    Boolean getEnable();
    
    /**
     * Return enable, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Enables the telnet server. Telnet is disabled by default
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enable, guaranteed to be non-null.
     * @throws NoSuchElementException if enable is not present
     *
     */
    default @NonNull Boolean requireEnable() {
        return CodeHelpers.require(getEnable(), "enable");
    }

}

