package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.ssh.server.top.SshServer;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.system.terminal.rev181121.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for ssh server data
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-terminal</b>
 * <pre>
 * grouping system-ssh-server-top {
 *   container ssh-server {
 *     container config {
 *       uses system-ssh-server-config;
 *     }
 *     container state {
 *       config false;
 *       uses system-ssh-server-config;
 *       uses system-ssh-server-state;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemSshServerTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("system-ssh-server-top");

    @Override
    Class<? extends SystemSshServerTop> implementedInterface();
    
    /**
     * Return sshServer, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for ssh server
     *     </code>
     * </pre>
     *
     * @return {@code SshServer} sshServer, or {@code null} if it is not present.
     *
     */
    SshServer getSshServer();
    
    /**
     * Return sshServer, or an empty instance if it is not present.
     *
     * @return {@code SshServer} sshServer, or an empty instance if it is not present.
     *
     */
    @NonNull SshServer nonnullSshServer();

}

