package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.system.terminal.rev181121.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for system ssh configuration
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-terminal</b>
 * <pre>
 * grouping system-ssh-server-config {
 *   leaf enable {
 *     type boolean;
 *     default true;
 *   }
 *   leaf protocol-version {
 *     type enumeration {
 *       enum V2 {
 *       }
 *       enum V1 {
 *       }
 *       enum V1_V2 {
 *       }
 *     }
 *     default V2;
 *   }
 *   uses system-terminal-common-config;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemSshServerConfig
    extends
    DataObject,
    SystemTerminalCommonConfig
{


    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>openconfig-system-terminal</b>
     * <pre>
     * leaf protocol-version {
     *   type enumeration {
     *     enum V2 {
     *     }
     *     enum V1 {
     *     }
     *     enum V1_V2 {
     *     }
     *   }
     *   default V2;
     * }
     * </pre>
     *
     */
    @Generated("mdsal-binding-generator")
    public enum ProtocolVersion implements EnumTypeObject {
        /**
         * Use SSH v2 only
         */
        V2(0, "V2"),
        
        /**
         * Use SSH v1 only
         */
        V1(1, "V1"),
        
        /**
         * Use either SSH v1 or v2
         */
        V1V2(2, "V1_V2")
        ;
    
        private final @NonNull String name;
        private final int value;
    
        private ProtocolVersion(int value, @NonNull String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public @NonNull String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding ProtocolVersion item, or {@code null} if no such item exists
         * @throws NullPointerException if {@code name} is null
         */
        public static @Nullable ProtocolVersion forName(String name) {
            return switch (name) {
                case "V2" -> V2;
                case "V1" -> V1;
                case "V1_V2" -> V1V2;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding ProtocolVersion item, or {@code null} if no such item exists
         */
        public static @Nullable ProtocolVersion forValue(int intValue) {
            return switch (intValue) {
                case 0 -> V2;
                case 1 -> V1;
                case 2 -> V1V2;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding ProtocolVersion item
         * @throws NullPointerException if {@code name} is null
         * @throws IllegalArgumentException if {@code name} does not match any item
         */
        public static @NonNull ProtocolVersion ofName(String name) {
            return CodeHelpers.checkEnum(forName(name), name);
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding ProtocolVersion item
         * @throws IllegalArgumentException if {@code intValue} does not match any item
         */
        public static @NonNull ProtocolVersion ofValue(int intValue) {
            return CodeHelpers.checkEnum(forValue(intValue), intValue);
        }
    }

    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("system-ssh-server-config");

    @Override
    Class<? extends SystemSshServerConfig> implementedInterface();
    
    /**
     * Return enable, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enables the ssh server. The ssh server is enabled by default.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enable, or {@code null} if it is not present.
     *
     */
    Boolean getEnable();
    
    /**
     * Return enable, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Enables the ssh server. The ssh server is enabled by default.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enable, guaranteed to be non-null.
     * @throws NoSuchElementException if enable is not present
     *
     */
    default @NonNull Boolean requireEnable() {
        return CodeHelpers.require(getEnable(), "enable");
    }
    
    /**
     * Return protocolVersion, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Set the protocol version for SSH connections to the system
     *     </code>
     * </pre>
     *
     * @return {@code ProtocolVersion} protocolVersion, or {@code null} if it is not present.
     *
     */
    ProtocolVersion getProtocolVersion();
    
    /**
     * Return protocolVersion, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Set the protocol version for SSH connections to the system
     *     </code>
     * </pre>
     *
     * @return {@code ProtocolVersion} protocolVersion, guaranteed to be non-null.
     * @throws NoSuchElementException if protocolVersion is not present
     *
     */
    default @NonNull ProtocolVersion requireProtocolVersion() {
        return CodeHelpers.require(getProtocolVersion(), "protocolversion");
    }

}

