package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.ntp.keys;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * This class represents the key of {@link NtpKey} class.
 *
 * @see NtpKey
 *
 */
@Generated("mdsal-binding-generator")
public class NtpKeyKey
 implements Key<NtpKey> {
    @java.io.Serial
    private static final long serialVersionUID = -90812754475690107L;
    private final Uint16 _keyId;


    /**
     * Constructs an instance.
     *
     * @param _keyId the entity keyId
     * @throws NullPointerException if any of the arguments are null
     */
    public NtpKeyKey(@NonNull Uint16 _keyId) {
        this._keyId = CodeHelpers.requireKeyProp(_keyId, "keyId");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public NtpKeyKey(NtpKeyKey source) {
        this._keyId = source._keyId;
    }


    /**
     * Return keyId, guaranteed to be non-null.
     *
     * @return {@code Uint16} keyId, guaranteed to be non-null.
     */
    public @NonNull Uint16 getKeyId() {
        return _keyId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_keyId);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof NtpKeyKey other
            && Objects.equals(_keyId, other._keyId);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(NtpKeyKey.class);
        CodeHelpers.appendValue(helper, "keyId", _keyId);
        return helper.toString();
    }
}

