package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.host.entries.host.entry;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemDnsStaticConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Ipv4Address;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Ipv6Address;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Config} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Config createConfig(int fooXyzzy, int barBaz) {
 *         return new ConfigBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Config, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Config
 *
 */
@Generated("mdsal-binding-generator")
public class ConfigBuilder {

    private Set<String> _alias;
    private String _hostname;
    private Set<Ipv4Address> _ipv4Address;
    private Set<Ipv6Address> _ipv6Address;


    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ConfigBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link SystemDnsStaticConfig}.
     *
     * @param arg SystemDnsStaticConfig from which the builder should be initialized
     */
    public ConfigBuilder(SystemDnsStaticConfig arg) {
        this._hostname = arg.getHostname();
        this._alias = arg.getAlias();
        this._ipv4Address = arg.getIpv4Address();
        this._ipv6Address = arg.getIpv6Address();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Config}.
     *
     * @param base Config from which the builder should be initialized
     */
    public ConfigBuilder(Config base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._alias = base.getAlias();
        this._hostname = base.getHostname();
        this._ipv4Address = base.getIpv4Address();
        this._ipv6Address = base.getIpv6Address();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link SystemDnsStaticConfig}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemDnsStaticConfig castArg) {
            this._hostname = castArg.getHostname();
            this._alias = castArg.getAlias();
            this._ipv4Address = castArg.getIpv4Address();
            this._ipv6Address = castArg.getIpv6Address();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SystemDnsStaticConfig]");
    }

    private static final class LazyEmpty {
        static final @NonNull Config INSTANCE = new ConfigBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of Config.
     *
     * @return An empty {@link Config}
     */
    public static @NonNull Config empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link Config#getAlias()}.
     *
     * @return current value
     */
    public Set<String> getAlias() {
        return _alias;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getHostname()}.
     *
     * @return current value
     */
    public String getHostname() {
        return _hostname;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getIpv4Address()}.
     *
     * @return current value
     */
    public Set<Ipv4Address> getIpv4Address() {
        return _ipv4Address;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getIpv6Address()}.
     *
     * @return current value
     */
    public Set<Ipv6Address> getIpv6Address() {
        return _ipv6Address;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Config#getAlias()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public ConfigBuilder setAlias(final Set<String> values) {
        this._alias = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link Config#getHostname()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setHostname(final String value) {
        this._hostname = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Config#getIpv4Address()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public ConfigBuilder setIpv4Address(final Set<Ipv4Address> values) {
        this._ipv4Address = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link Config#getIpv6Address()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public ConfigBuilder setIpv6Address(final Set<Ipv6Address> values) {
        this._ipv6Address = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Config} instance.
     *
     * @return A new {@link Config} instance.
     */
    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
        extends AbstractAugmentable<Config>
        implements Config {
    
        private final Set<String> _alias;
        private final String _hostname;
        private final Set<Ipv4Address> _ipv4Address;
        private final Set<Ipv6Address> _ipv6Address;
    
        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._alias = base.getAlias();
            this._hostname = base.getHostname();
            this._ipv4Address = base.getIpv4Address();
            this._ipv6Address = base.getIpv6Address();
        }
    
        @Override
        public Set<String> getAlias() {
            return _alias;
        }
        
        @Override
        public String getHostname() {
            return _hostname;
        }
        
        @Override
        public Set<Ipv4Address> getIpv4Address() {
            return _ipv4Address;
        }
        
        @Override
        public Set<Ipv6Address> getIpv6Address() {
            return _ipv6Address;
        }
    
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Config.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Config.bindingToString(this);
        }
    }
}
