package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.host.entries;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;

/**
 * This class represents the key of {@link HostEntry} class.
 *
 * @see HostEntry
 *
 */
@Generated("mdsal-binding-generator")
public class HostEntryKey
 implements Key<HostEntry> {
    @java.io.Serial
    private static final long serialVersionUID = 7986486545218513183L;
    private final String _hostname;


    /**
     * Constructs an instance.
     *
     * @param _hostname the entity hostname
     * @throws NullPointerException if any of the arguments are null
     */
    public HostEntryKey(@NonNull String _hostname) {
        this._hostname = CodeHelpers.requireKeyProp(_hostname, "hostname");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public HostEntryKey(HostEntryKey source) {
        this._hostname = source._hostname;
    }


    /**
     * Return hostname, guaranteed to be non-null.
     *
     * @return {@code String} hostname, guaranteed to be non-null.
     */
    public @NonNull String getHostname() {
        return _hostname;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_hostname);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof HostEntryKey other
            && Objects.equals(_hostname, other._hostname);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(HostEntryKey.class);
        CodeHelpers.appendValue(helper, "hostname", _hostname);
        return helper.toString();
    }
}

