package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.AvgMinMaxInstantStatsPct;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemCpuState;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.system.rev200413.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Percentage of CPU time spent idle.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * container idle {
 *   uses oc-types:avg-min-max-instant-stats-pct;
 * }
 * </pre>
 * <p>To create instances of this class use {@link IdleBuilder}.
 * @see IdleBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Idle
    extends
    ChildOf<SystemCpuState>,
    Augmentable<Idle>,
    AvgMinMaxInstantStatsPct
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("idle");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Idle> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Idle.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.@NonNull Idle obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getAvg());
        result = prime * result + Objects.hashCode(obj.getInstant());
        result = prime * result + Objects.hashCode(obj.getInterval());
        result = prime * result + Objects.hashCode(obj.getMax());
        result = prime * result + Objects.hashCode(obj.getMaxTime());
        result = prime * result + Objects.hashCode(obj.getMin());
        result = prime * result + Objects.hashCode(obj.getMinTime());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.@NonNull Idle thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Idle.class, obj);
        return other != null
            && Objects.equals(thisObj.getAvg(), other.getAvg())
            && Objects.equals(thisObj.getInstant(), other.getInstant())
            && Objects.equals(thisObj.getInterval(), other.getInterval())
            && Objects.equals(thisObj.getMax(), other.getMax())
            && Objects.equals(thisObj.getMaxTime(), other.getMaxTime())
            && Objects.equals(thisObj.getMin(), other.getMin())
            && Objects.equals(thisObj.getMinTime(), other.getMinTime())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.@NonNull Idle obj) {
        final var helper = MoreObjects.toStringHelper("Idle");
        CodeHelpers.appendValue(helper, "avg", obj.getAvg());
        CodeHelpers.appendValue(helper, "instant", obj.getInstant());
        CodeHelpers.appendValue(helper, "interval", obj.getInterval());
        CodeHelpers.appendValue(helper, "max", obj.getMax());
        CodeHelpers.appendValue(helper, "maxTime", obj.getMaxTime());
        CodeHelpers.appendValue(helper, "min", obj.getMin());
        CodeHelpers.appendValue(helper, "minTime", obj.getMinTime());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

