package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.system.rev200413.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Operational state data for NTP servers
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-ntp-server-state {
 *   leaf stratum {
 *     type uint8;
 *   }
 *   leaf root-delay {
 *     type uint32;
 *     units milliseconds;
 *   }
 *   leaf root-dispersion {
 *     type uint64;
 *     units milliseconds;
 *   }
 *   leaf offset {
 *     type uint64;
 *     units milliseconds;
 *   }
 *   leaf poll-interval {
 *     type uint32;
 *     units seconds;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemNtpServerState
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("system-ntp-server-state");

    @Override
    Class<? extends SystemNtpServerState> implementedInterface();
    
    /**
     * Return stratum, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Indicates the level of the server in the NTP hierarchy. As stratum number
     *         increases, the accuracy is degraded. Primary servers are stratum while a maximum
     *         value of 16 indicates unsynchronized. The values have the following specific
     *         semantics: | 0 | unspecified or invalid | 1 | primary server (e.g., equipped
     *         with a GPS receiver) | 2-15 | secondary server (via NTP) | 16 | unsynchronized |
     *         17-255 | reserved
     *     </code>
     * </pre>
     *
     * @return {@code Uint8} stratum, or {@code null} if it is not present.
     *
     */
    Uint8 getStratum();
    
    /**
     * Return stratum, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Indicates the level of the server in the NTP hierarchy. As stratum number
     *         increases, the accuracy is degraded. Primary servers are stratum while a maximum
     *         value of 16 indicates unsynchronized. The values have the following specific
     *         semantics: | 0 | unspecified or invalid | 1 | primary server (e.g., equipped
     *         with a GPS receiver) | 2-15 | secondary server (via NTP) | 16 | unsynchronized |
     *         17-255 | reserved
     *     </code>
     * </pre>
     *
     * @return {@code Uint8} stratum, guaranteed to be non-null.
     * @throws NoSuchElementException if stratum is not present
     *
     */
    default @NonNull Uint8 requireStratum() {
        return CodeHelpers.require(getStratum(), "stratum");
    }
    
    /**
     * Return rootDelay, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The round-trip delay to the server, in milliseconds.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} rootDelay, or {@code null} if it is not present.
     *
     */
    Uint32 getRootDelay();
    
    /**
     * Return rootDelay, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The round-trip delay to the server, in milliseconds.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} rootDelay, guaranteed to be non-null.
     * @throws NoSuchElementException if rootDelay is not present
     *
     */
    default @NonNull Uint32 requireRootDelay() {
        return CodeHelpers.require(getRootDelay(), "rootdelay");
    }
    
    /**
     * Return rootDispersion, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Dispersion (epsilon) represents the maximum error inherent in the measurement
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} rootDispersion, or {@code null} if it is not present.
     *
     */
    Uint64 getRootDispersion();
    
    /**
     * Return rootDispersion, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Dispersion (epsilon) represents the maximum error inherent in the measurement
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} rootDispersion, guaranteed to be non-null.
     * @throws NoSuchElementException if rootDispersion is not present
     *
     */
    default @NonNull Uint64 requireRootDispersion() {
        return CodeHelpers.require(getRootDispersion(), "rootdispersion");
    }
    
    /**
     * Return offset, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Estimate of the current time offset from the peer. This is the time difference
     *         between the local and reference clock.
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} offset, or {@code null} if it is not present.
     *
     */
    Uint64 getOffset();
    
    /**
     * Return offset, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Estimate of the current time offset from the peer. This is the time difference
     *         between the local and reference clock.
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} offset, guaranteed to be non-null.
     * @throws NoSuchElementException if offset is not present
     *
     */
    default @NonNull Uint64 requireOffset() {
        return CodeHelpers.require(getOffset(), "offset");
    }
    
    /**
     * Return pollInterval, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Polling interval of the peer
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} pollInterval, or {@code null} if it is not present.
     *
     */
    Uint32 getPollInterval();
    
    /**
     * Return pollInterval, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Polling interval of the peer
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} pollInterval, guaranteed to be non-null.
     * @throws NoSuchElementException if pollInterval is not present
     *
     */
    default @NonNull Uint32 requirePollInterval() {
        return CodeHelpers.require(getPollInterval(), "pollinterval");
    }

}

