package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.system.rev200413.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for system-wide NTP operation.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-ntp-config {
 *   leaf enabled {
 *     type boolean;
 *     default false;
 *   }
 *   leaf ntp-source-address {
 *     type oc-inet:ip-address;
 *   }
 *   leaf enable-ntp-auth {
 *     type boolean;
 *     default false;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemNtpConfig
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("system-ntp-config");

    @Override
    Class<? extends SystemNtpConfig> implementedInterface();
    
    /**
     * Return enabled, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enables the NTP protocol and indicates that the system should attempt to
     *         synchronize the system clock with an NTP server from the servers defined in the
     *         'ntp/server' list.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enabled, or {@code null} if it is not present.
     *
     */
    Boolean getEnabled();
    
    /**
     * Return enabled, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Enables the NTP protocol and indicates that the system should attempt to
     *         synchronize the system clock with an NTP server from the servers defined in the
     *         'ntp/server' list.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enabled, guaranteed to be non-null.
     * @throws NoSuchElementException if enabled is not present
     *
     */
    default @NonNull Boolean requireEnabled() {
        return CodeHelpers.require(getEnabled(), "enabled");
    }
    
    /**
     * Return ntpSourceAddress, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Source address to use on outgoing NTP packets
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} ntpSourceAddress, or {@code null} if it is not present.
     *
     */
    IpAddress getNtpSourceAddress();
    
    /**
     * Return ntpSourceAddress, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Source address to use on outgoing NTP packets
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} ntpSourceAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if ntpSourceAddress is not present
     *
     */
    default @NonNull IpAddress requireNtpSourceAddress() {
        return CodeHelpers.require(getNtpSourceAddress(), "ntpsourceaddress");
    }
    
    /**
     * Return enableNtpAuth, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enable or disable NTP authentication -- when enabled, the system will only use
     *         packets containing a trusted authentication key to synchronize the time.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enableNtpAuth, or {@code null} if it is not present.
     *
     */
    Boolean getEnableNtpAuth();
    
    /**
     * Return enableNtpAuth, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Enable or disable NTP authentication -- when enabled, the system will only use
     *         packets containing a trusted authentication key to synchronize the time.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enableNtpAuth, guaranteed to be non-null.
     * @throws NoSuchElementException if enableNtpAuth is not present
     *
     */
    default @NonNull Boolean requireEnableNtpAuth() {
        return CodeHelpers.require(getEnableNtpAuth(), "enablentpauth");
    }

}

