package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * Model for managing system-wide services and functions on network devices. 
 * Portions of this code were derived from IETF RFC 7317. Please reproduce this 
 * note if possible. IETF code is subject to the following copyright and license: 
 * Copyright (c) IETF Trust and the persons identified as authors of the code. All 
 * rights reserved. Redistribution and use in source and binary forms, with or 
 * without modification, is permitted pursuant to, and subject to the license 
 * contained in, the Simplified BSD License set forth in Section 4.c of the IETF 
 * Trust's Legal Provisions Relating to IETF Documents 
 * (http://trustee.ietf.org/license-info).
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * module openconfig-system {
 *   yang-version 1;
 *   namespace "http://openconfig.net/yang/system";
 *   prefix oc-sys;
 *   import openconfig-inet-types {
 *     prefix oc-inet;
 *   }
 *   import openconfig-yang-types {
 *     prefix oc-yang;
 *   }
 *   import openconfig-types {
 *     prefix oc-types;
 *   }
 *   import openconfig-extensions {
 *     prefix oc-ext;
 *   }
 *   import openconfig-aaa {
 *     prefix oc-aaa;
 *   }
 *   import openconfig-system-logging {
 *     prefix oc-log;
 *   }
 *   import openconfig-system-terminal {
 *     prefix oc-sys-term;
 *   }
 *   import openconfig-procmon {
 *     prefix oc-proc;
 *   }
 *   import openconfig-alarms {
 *     prefix oc-alarms;
 *   }
 *   import openconfig-messages {
 *     prefix oc-messages;
 *   }
 *   import openconfig-license {
 *     prefix oc-license;
 *   }
 *   oc-ext:openconfig-version 0.10.0;
 *   revision 2020-04-13 {
 *   }
 *   revision 2020-03-25 {
 *   }
 *   revision 2020-01-07 {
 *   }
 *   revision 2019-03-15 {
 *   }
 *   revision 2019-01-29 {
 *   }
 *   revision 2018-11-21 {
 *   }
 *   revision 2018-07-17 {
 *   }
 *   revision 2018-01-21 {
 *   }
 *   revision 2017-12-15 {
 *   }
 *   revision 2017-09-18 {
 *   }
 *   revision 2017-07-06 {
 *   }
 *   revision 2017-01-29 {
 *   }
 *   oc-ext:regexp-posix;
 *   oc-ext:catalog-organization openconfig;
 *   oc-ext:origin openconfig;
 *   identity NTP_AUTH_TYPE {
 *   }
 *   identity NTP_AUTH_MD5 {
 *     base NTP_AUTH_TYPE;
 *   }
 *   typedef timezone-name-type {
 *     type string;
 *   }
 *   grouping system-clock-config {
 *     leaf timezone-name {
 *       type timezone-name-type;
 *     }
 *   }
 *   grouping system-clock-state {
 *   }
 *   grouping system-clock-top {
 *     container clock {
 *       container config {
 *         uses system-clock-config;
 *       }
 *       container state {
 *         config false;
 *         uses system-clock-config;
 *         uses system-clock-state;
 *       }
 *     }
 *   }
 *   grouping system-global-config {
 *     leaf hostname {
 *       type oc-inet:domain-name;
 *     }
 *     leaf domain-name {
 *       type oc-inet:domain-name;
 *     }
 *     leaf login-banner {
 *       type string;
 *     }
 *     leaf motd-banner {
 *       type string;
 *     }
 *   }
 *   grouping system-global-state {
 *     leaf current-datetime {
 *       type oc-yang:date-and-time;
 *     }
 *     leaf boot-time {
 *       type oc-types:timeticks64;
 *       units nanoseconds;
 *     }
 *   }
 *   grouping system-dns-config {
 *     leaf-list search {
 *       type oc-inet:domain-name;
 *       ordered-by user;
 *     }
 *   }
 *   grouping system-dns-state {
 *   }
 *   grouping system-dns-servers-config {
 *     leaf address {
 *       type oc-inet:ip-address;
 *     }
 *     leaf port {
 *       type oc-inet:port-number;
 *       default 53;
 *     }
 *   }
 *   grouping system-dns-static-config {
 *     leaf hostname {
 *       type string;
 *     }
 *     leaf-list alias {
 *       type string;
 *     }
 *     leaf-list ipv4-address {
 *       type oc-inet:ipv4-address;
 *     }
 *     leaf-list ipv6-address {
 *       type oc-inet:ipv6-address;
 *     }
 *   }
 *   grouping system-dns-static-state {
 *   }
 *   grouping system-dns-static-top {
 *     container host-entries {
 *       list host-entry {
 *         key hostname;
 *         leaf hostname {
 *           type leafref {
 *             path ../config/hostname;
 *           }
 *         }
 *         container config {
 *           uses system-dns-static-config;
 *         }
 *         container state {
 *           config false;
 *           uses system-dns-static-config;
 *           uses system-dns-static-state;
 *         }
 *       }
 *     }
 *   }
 *   grouping system-dns-servers-state {
 *   }
 *   grouping system-dns-servers-top {
 *     container servers {
 *       list server {
 *         key address;
 *         ordered-by user;
 *         leaf address {
 *           type leafref {
 *             path ../config/address;
 *           }
 *         }
 *         container config {
 *           uses system-dns-servers-config;
 *         }
 *         container state {
 *           config false;
 *           uses system-dns-servers-config;
 *           uses system-dns-servers-state;
 *         }
 *       }
 *     }
 *   }
 *   grouping system-dns-top {
 *     container dns {
 *       container config {
 *         uses system-dns-config;
 *       }
 *       container state {
 *         config false;
 *         uses system-dns-config;
 *         uses system-dns-state;
 *       }
 *       uses system-dns-servers-top;
 *       uses system-dns-static-top;
 *     }
 *   }
 *   grouping system-ntp-server-config {
 *     leaf address {
 *       type oc-inet:host;
 *     }
 *     leaf port {
 *       type oc-inet:port-number;
 *       default 123;
 *     }
 *     leaf version {
 *       type uint8 {
 *         range 1..4;
 *       }
 *       default 4;
 *     }
 *     leaf association-type {
 *       type enumeration {
 *         enum SERVER {
 *         }
 *         enum PEER {
 *         }
 *         enum POOL {
 *         }
 *       }
 *       default SERVER;
 *     }
 *     leaf iburst {
 *       type boolean;
 *       default false;
 *     }
 *     leaf prefer {
 *       type boolean;
 *       default false;
 *     }
 *   }
 *   grouping system-ntp-server-state {
 *     leaf stratum {
 *       type uint8;
 *     }
 *     leaf root-delay {
 *       type uint32;
 *       units milliseconds;
 *     }
 *     leaf root-dispersion {
 *       type uint64;
 *       units milliseconds;
 *     }
 *     leaf offset {
 *       type uint64;
 *       units milliseconds;
 *     }
 *     leaf poll-interval {
 *       type uint32;
 *       units seconds;
 *     }
 *   }
 *   grouping system-ntp-server-top {
 *     container servers {
 *       list server {
 *         key address;
 *         leaf address {
 *           type leafref {
 *             path ../config/address;
 *           }
 *         }
 *         container config {
 *           uses system-ntp-server-config;
 *         }
 *         container state {
 *           config false;
 *           uses system-ntp-server-config;
 *           uses system-ntp-server-state;
 *         }
 *       }
 *     }
 *   }
 *   grouping system-ntp-auth-keys-config {
 *     leaf key-id {
 *       type uint16;
 *     }
 *     leaf key-type {
 *       type identityref {
 *         base NTP_AUTH_TYPE;
 *       }
 *     }
 *     leaf key-value {
 *       type string;
 *     }
 *   }
 *   grouping system-ntp-auth-keys-state {
 *   }
 *   grouping system-ntp-auth-keys-top {
 *     container ntp-keys {
 *       list ntp-key {
 *         key key-id;
 *         leaf key-id {
 *           type leafref {
 *             path ../config/key-id;
 *           }
 *         }
 *         container config {
 *           uses system-ntp-auth-keys-config;
 *         }
 *         container state {
 *           config false;
 *           uses system-ntp-auth-keys-config;
 *           uses system-ntp-auth-keys-state;
 *         }
 *       }
 *     }
 *   }
 *   grouping system-ntp-config {
 *     leaf enabled {
 *       type boolean;
 *       default false;
 *     }
 *     leaf ntp-source-address {
 *       type oc-inet:ip-address;
 *     }
 *     leaf enable-ntp-auth {
 *       type boolean;
 *       default false;
 *     }
 *   }
 *   grouping system-ntp-state {
 *     leaf auth-mismatch {
 *       type oc-yang:counter64;
 *     }
 *   }
 *   grouping system-ntp-top {
 *     container ntp {
 *       container config {
 *         uses system-ntp-config;
 *       }
 *       container state {
 *         config false;
 *         uses system-ntp-config;
 *         uses system-ntp-state;
 *       }
 *       uses system-ntp-auth-keys-top;
 *       uses system-ntp-server-top;
 *     }
 *   }
 *   grouping system-memory-config {
 *   }
 *   grouping system-memory-state {
 *     leaf physical {
 *       type uint64;
 *       units bytes;
 *     }
 *     leaf reserved {
 *       type uint64;
 *       units bytes;
 *     }
 *   }
 *   grouping system-memory-top {
 *     container memory {
 *       container config {
 *         uses system-memory-config;
 *       }
 *       container state {
 *         config false;
 *         uses system-memory-config;
 *         uses system-memory-state;
 *       }
 *     }
 *   }
 *   grouping system-cpu-state {
 *     leaf index {
 *       type union {
 *         type enumeration {
 *           enum ALL {
 *           }
 *         }
 *         type uint32;
 *       }
 *     }
 *     container total {
 *       uses oc-types:avg-min-max-instant-stats-pct;
 *     }
 *     container user {
 *       uses oc-types:avg-min-max-instant-stats-pct;
 *     }
 *     container kernel {
 *       uses oc-types:avg-min-max-instant-stats-pct;
 *     }
 *     container nice {
 *       uses oc-types:avg-min-max-instant-stats-pct;
 *     }
 *     container idle {
 *       uses oc-types:avg-min-max-instant-stats-pct;
 *     }
 *     container wait {
 *       uses oc-types:avg-min-max-instant-stats-pct;
 *     }
 *     container hardware-interrupt {
 *       uses oc-types:avg-min-max-instant-stats-pct;
 *     }
 *     container software-interrupt {
 *       uses oc-types:avg-min-max-instant-stats-pct;
 *     }
 *   }
 *   grouping system-cpu-top {
 *     container cpus {
 *       config false;
 *       list cpu {
 *         key index;
 *         leaf index {
 *           type leafref {
 *             path ../state/index;
 *           }
 *         }
 *         container state {
 *           uses system-cpu-state;
 *         }
 *       }
 *     }
 *   }
 *   grouping system-top {
 *     container system {
 *       container config {
 *         uses system-global-config;
 *       }
 *       container state {
 *         config false;
 *         uses system-global-config;
 *         uses system-global-state;
 *       }
 *       uses system-clock-top;
 *       uses system-dns-top;
 *       uses system-ntp-top;
 *       uses oc-sys-term:system-ssh-server-top;
 *       uses oc-sys-term:system-telnet-server-top;
 *       uses oc-log:logging-top;
 *       uses oc-aaa:aaa-top;
 *       uses system-memory-top;
 *       uses system-cpu-top;
 *       uses oc-proc:procmon-processes-top;
 *       uses oc-alarms:alarms-top;
 *       uses oc-messages:messages-top;
 *       uses oc-license:license-top;
 *     }
 *   }
 *   uses system-top;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenconfigSystemData
    extends
    DataRoot,
    SystemTop
{





}

