package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.ProcmonProcessesTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.Process;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.ProcessKey;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.system.procmon.rev190315.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Parameters related to all monitored processes
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-procmon</b>
 * <pre>
 * container processes {
 *   list process {
 *     key pid;
 *     config false;
 *     leaf pid {
 *       type leafref {
 *         path ../state/pid;
 *       }
 *     }
 *     container state {
 *       config false;
 *       uses procmon-process-attributes-state;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link ProcessesBuilder}.
 * @see ProcessesBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Processes
    extends
    ChildOf<ProcmonProcessesTop>,
    Augmentable<Processes>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("processes");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.Processes> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.Processes.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.@NonNull Processes obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getProcess());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.@NonNull Processes thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.Processes.class, obj);
        return other != null
            && Objects.equals(thisObj.getProcess(), other.getProcess())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.@NonNull Processes obj) {
        final var helper = MoreObjects.toStringHelper("Processes");
        CodeHelpers.appendValue(helper, "process", obj.getProcess());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return process, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of monitored processes
     *     </code>
     * </pre>
     *
     * @return {@code Map<ProcessKey, Process>} process, or {@code null} if it is not present.
     *
     */
    @Nullable Map<ProcessKey, Process> getProcess();
    
    /**
     * Return process, or an empty list if it is not present.
     *
     * @return {@code Map<ProcessKey, Process>} process, or an empty list if it is not present.
     *
     */
    default @NonNull Map<ProcessKey, Process> nonnullProcess() {
        return CodeHelpers.nonnull(getProcess());
    }

}

