package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.top.Logging;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.system.logging.rev181121.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for logging data
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-logging</b>
 * <pre>
 * grouping logging-top {
 *   container logging {
 *     uses logging-console-top;
 *     uses logging-remote-top;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface LoggingTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("logging-top");

    @Override
    Class<? extends LoggingTop> implementedInterface();
    
    /**
     * Return logging, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for data related to logging / syslog
     *     </code>
     * </pre>
     *
     * @return {@code Logging} logging, or {@code null} if it is not present.
     *
     */
    Logging getLogging();
    
    /**
     * Return logging, or an empty instance if it is not present.
     *
     * @return {@code Logging} logging, or an empty instance if it is not present.
     *
     */
    @NonNull Logging nonnullLogging();

}

