package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.RemoteServers;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.system.logging.rev181121.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for remote log servers
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-logging</b>
 * <pre>
 * grouping logging-remote-top {
 *   container remote-servers {
 *     list remote-server {
 *       key host;
 *       leaf host {
 *         type leafref {
 *           path ../config/host;
 *         }
 *       }
 *       container config {
 *         uses logging-remote-config;
 *       }
 *       container state {
 *         config false;
 *         uses logging-remote-config;
 *         uses logging-remote-state;
 *       }
 *       uses logging-selectors-top;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface LoggingRemoteTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("logging-remote-top");

    @Override
    Class<? extends LoggingRemoteTop> implementedInterface();
    
    /**
     * Return remoteServers, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container for the list of remote log servers
     *     </code>
     * </pre>
     *
     * @return {@code RemoteServers} remoteServers, or {@code null} if it is not present.
     *
     */
    RemoteServers getRemoteServers();
    
    /**
     * Return remoteServers, or an empty instance if it is not present.
     *
     * @return {@code RemoteServers} remoteServers, or an empty instance if it is not present.
     *
     */
    @NonNull RemoteServers nonnullRemoteServers();

}

