package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Host;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.system.logging.rev181121.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for remote log servers
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-logging</b>
 * <pre>
 * grouping logging-remote-config {
 *   leaf host {
 *     type oc-inet:host;
 *   }
 *   leaf source-address {
 *     type oc-inet:ip-address;
 *   }
 *   leaf remote-port {
 *     type oc-inet:port-number;
 *     default 514;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface LoggingRemoteConfig
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("logging-remote-config");

    @Override
    Class<? extends LoggingRemoteConfig> implementedInterface();
    
    /**
     * Return host, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         IP address or hostname of the remote log server
     *     </code>
     * </pre>
     *
     * @return {@code Host} host, or {@code null} if it is not present.
     *
     */
    Host getHost();
    
    /**
     * Return host, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         IP address or hostname of the remote log server
     *     </code>
     * </pre>
     *
     * @return {@code Host} host, guaranteed to be non-null.
     * @throws NoSuchElementException if host is not present
     *
     */
    default @NonNull Host requireHost() {
        return CodeHelpers.require(getHost(), "host");
    }
    
    /**
     * Return sourceAddress, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Source IP address for packets to the log server
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} sourceAddress, or {@code null} if it is not present.
     *
     */
    IpAddress getSourceAddress();
    
    /**
     * Return sourceAddress, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Source IP address for packets to the log server
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} sourceAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if sourceAddress is not present
     *
     */
    default @NonNull IpAddress requireSourceAddress() {
        return CodeHelpers.require(getSourceAddress(), "sourceaddress");
    }
    
    /**
     * Return remotePort, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Sets the destination port number for syslog UDP messages to the server. The
     *         default for syslog is 514.
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} remotePort, or {@code null} if it is not present.
     *
     */
    PortNumber getRemotePort();
    
    /**
     * Return remotePort, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Sets the destination port number for syslog UDP messages to the server. The
     *         default for syslog is 514.
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} remotePort, guaranteed to be non-null.
     * @throws NoSuchElementException if remotePort is not present
     *
     */
    default @NonNull PortNumber requireRemotePort() {
        return CodeHelpers.require(getRemotePort(), "remoteport");
    }

}

