package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.console.top.Console;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.system.logging.rev181121.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for console logging data
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-logging</b>
 * <pre>
 * grouping logging-console-top {
 *   container console {
 *     container config {
 *       uses logging-console-config;
 *     }
 *     container state {
 *       config false;
 *       uses logging-console-config;
 *       uses logging-console-state;
 *     }
 *     uses logging-selectors-top;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface LoggingConsoleTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("logging-console-top");

    @Override
    Class<? extends LoggingConsoleTop> implementedInterface();
    
    /**
     * Return console, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for data related to console-based logging
     *     </code>
     * </pre>
     *
     * @return {@code Console} console, or {@code null} if it is not present.
     *
     */
    Console getConsole();
    
    /**
     * Return console, or an empty instance if it is not present.
     *
     * @return {@code Console} console, or an empty instance if it is not present.
     *
     */
    @NonNull Console nonnullConsole();

}

