package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.types.rev210118;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.platform.types.rev210118.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * A base identity for software modules installed and/or running on the device. 
 * Modules include user-space programs and kernel modules that provide specific 
 * functionality. A component with type SOFTWARE_MODULE should also have a module 
 * type that indicates the specific type of software module
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform-types</b>
 * <pre>
 * identity SOFTWARE_MODULE {
 *   base OPENCONFIG_SOFTWARE_COMPONENT;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SOFTWAREMODULE
    extends
    OPENCONFIGSOFTWARECOMPONENT
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("SOFTWARE_MODULE");
    /**
     * Singleton value representing the {@link SOFTWAREMODULE} identity.
     */
    public static final @NonNull SOFTWAREMODULE VALUE = new SOFTWAREMODULE() {
        @Override
        public Class<SOFTWAREMODULE> implementedInterface() {
            return SOFTWAREMODULE.class;
        }
    
        @Override
        public int hashCode() {
            return SOFTWAREMODULE.class.hashCode();
        }
    
        @Override
        public boolean equals(final Object obj) {
            return obj == this || obj instanceof SOFTWAREMODULE other
                && SOFTWAREMODULE.class.equals(other.implementedInterface());
        }
    
        @Override
        public String toString() {
            return MoreObjects.toStringHelper("SOFTWAREMODULE").add("qname", QNAME).toString();
        }
    };

    @Override
    Class<? extends SOFTWAREMODULE> implementedInterface();

}

