package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.types.rev210118;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.platform.types.rev210118.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * An operating system update - which should be a subcomponent of the 
 * `OPERATING_SYSTEM` running on a component. An update is defined to be a set of 
 * software changes that are atomically installed (and uninstalled) together. 
 * Multiple updates may be present for the Operating System. A system should not 
 * list all installed software packages using this type -- but rather updates that 
 * are bundled together as a single installable item
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform-types</b>
 * <pre>
 * identity OPERATING_SYSTEM_UPDATE {
 *   base OPENCONFIG_SOFTWARE_COMPONENT;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OPERATINGSYSTEMUPDATE
    extends
    OPENCONFIGSOFTWARECOMPONENT
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("OPERATING_SYSTEM_UPDATE");
    /**
     * Singleton value representing the {@link OPERATINGSYSTEMUPDATE} identity.
     */
    public static final @NonNull OPERATINGSYSTEMUPDATE VALUE = new OPERATINGSYSTEMUPDATE() {
        @Override
        public Class<OPERATINGSYSTEMUPDATE> implementedInterface() {
            return OPERATINGSYSTEMUPDATE.class;
        }
    
        @Override
        public int hashCode() {
            return OPERATINGSYSTEMUPDATE.class.hashCode();
        }
    
        @Override
        public boolean equals(final Object obj) {
            return obj == this || obj instanceof OPERATINGSYSTEMUPDATE other
                && OPERATINGSYSTEMUPDATE.class.equals(other.implementedInterface());
        }
    
        @Override
        public String toString() {
            return MoreObjects.toStringHelper("OPERATINGSYSTEMUPDATE").add("qname", QNAME).toString();
        }
    };

    @Override
    Class<? extends OPERATINGSYSTEMUPDATE> implementedInterface();

}

