package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.types.rev210118;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.platform.types.rev210118.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Backplane component for aggregating traffic, typically contained in a chassis 
 * component
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform-types</b>
 * <pre>
 * identity BACKPLANE {
 *   base OPENCONFIG_HARDWARE_COMPONENT;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface BACKPLANE
    extends
    OPENCONFIGHARDWARECOMPONENT
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("BACKPLANE");
    /**
     * Singleton value representing the {@link BACKPLANE} identity.
     */
    public static final @NonNull BACKPLANE VALUE = new BACKPLANE() {
        @Override
        public Class<BACKPLANE> implementedInterface() {
            return BACKPLANE.class;
        }
    
        @Override
        public int hashCode() {
            return BACKPLANE.class.hashCode();
        }
    
        @Override
        public boolean equals(final Object obj) {
            return obj == this || obj instanceof BACKPLANE other
                && BACKPLANE.class.equals(other.implementedInterface());
        }
    
        @Override
        public String toString() {
            return MoreObjects.toStringHelper("BACKPLANE").add("qname", QNAME).toString();
        }
    };

    @Override
    Class<? extends BACKPLANE> implementedInterface();

}

