package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentPropertiesTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.properties.Property;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.properties.PropertyKey;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.platform.rev210118.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container 
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * container properties {
 *   list property {
 *     key name;
 *     leaf name {
 *       type leafref {
 *         path ../config/name;
 *       }
 *     }
 *     container config {
 *       uses platform-component-properties-config;
 *     }
 *     container state {
 *       config false;
 *       uses platform-component-properties-config;
 *       uses platform-component-properties-state;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link PropertiesBuilder}.
 * @see PropertiesBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Properties
    extends
    ChildOf<PlatformComponentPropertiesTop>,
    Augmentable<Properties>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("properties");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.Properties> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.Properties.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.@NonNull Properties obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getProperty());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.@NonNull Properties thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.Properties.class, obj);
        return other != null
            && Objects.equals(thisObj.getProperty(), other.getProperty())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.@NonNull Properties obj) {
        final var helper = MoreObjects.toStringHelper("Properties");
        CodeHelpers.appendValue(helper, "property", obj.getProperty());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return property, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of system properties for the component
     *     </code>
     * </pre>
     *
     * @return {@code Map<PropertyKey, Property>} property, or {@code null} if it is not present.
     *
     */
    @Nullable Map<PropertyKey, Property> getProperty();
    
    /**
     * Return property, or an empty list if it is not present.
     *
     * @return {@code Map<PropertyKey, Property>} property, or an empty list if it is not present.
     *
     */
    default @NonNull Map<PropertyKey, Property> nonnullProperty() {
        return CodeHelpers.nonnull(getProperty());
    }

}

