package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.platform.rev210118.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for subcomponent references
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * grouping platform-subcomponent-ref-config {
 *   leaf name {
 *     type leafref {
 *       path ../../../../../component/config/name;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface PlatformSubcomponentRefConfig
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("platform-subcomponent-ref-config");

    @Override
    Class<? extends PlatformSubcomponentRefConfig> implementedInterface();
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Reference to the name of the subcomponent
     *     </code>
     * </pre>
     *
     * @return {@code Object} name, or {@code null} if it is not present.
     *
     */
    Object getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Reference to the name of the subcomponent
     *     </code>
     * </pre>
     *
     * @return {@code Object} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull Object requireName() {
        return CodeHelpers.require(getName(), "name");
    }

}

