package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.temp.state.Temperature;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.platform.rev210118.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Temperature state data for device components
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * grouping platform-component-temp-state {
 *   container temperature {
 *     uses oc-platform-types:avg-min-max-instant-stats-precision1-celsius;
 *     uses platform-component-temp-alarm-state;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface PlatformComponentTempState
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("platform-component-temp-state");

    @Override
    Class<? extends PlatformComponentTempState> implementedInterface();
    
    /**
     * Return temperature, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Temperature in degrees Celsius of the component. Values include the
     *         instantaneous, average, minimum, and maximum statistics. If avg/min/max
     *         statistics are not supported, the target is expected to just supply the instant
     *         value
     *     </code>
     * </pre>
     *
     * @return {@code Temperature} temperature, or {@code null} if it is not present.
     *
     */
    Temperature getTemperature();
    
    /**
     * Return temperature, or an empty instance if it is not present.
     *
     * @return {@code Temperature} temperature, or an empty instance if it is not present.
     *
     */
    @NonNull Temperature nonnullTemperature();

}

