package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Backplane;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Chassis;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Cpu;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Fabric;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Fan;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.IntegratedCircuit;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Port;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.PowerSupply;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.SoftwareModule;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Storage;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.platform.rev210118.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * This grouping is used to add containers for components that are common across 
 * systems, but do not have a defined schema within the openconfig-platform 
 * Containers should be added to this grouping for components that are expected to 
 * exist in multiple systems, with corresponding modules augmenting the 
 * config/state containers directly.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * grouping platform-anchors-top {
 *   container chassis {
 *     container config {
 *     }
 *     container state {
 *       config false;
 *     }
 *   }
 *   container port {
 *     container config {
 *     }
 *     container state {
 *       config false;
 *     }
 *   }
 *   container power-supply {
 *     container config {
 *     }
 *     container state {
 *       config false;
 *     }
 *   }
 *   container fan {
 *     container config {
 *     }
 *     container state {
 *       config false;
 *     }
 *   }
 *   container fabric {
 *     container config {
 *     }
 *     container state {
 *       config false;
 *     }
 *   }
 *   container storage {
 *     container config {
 *     }
 *     container state {
 *       config false;
 *     }
 *   }
 *   container cpu {
 *     container config {
 *     }
 *     container state {
 *       config false;
 *     }
 *   }
 *   container integrated-circuit {
 *     container config {
 *     }
 *     container state {
 *       config false;
 *     }
 *   }
 *   container backplane {
 *     container config {
 *     }
 *     container state {
 *       config false;
 *     }
 *   }
 *   container software-module {
 *     container config {
 *     }
 *     container state {
 *       config false;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface PlatformAnchorsTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("platform-anchors-top");

    @Override
    Class<? extends PlatformAnchorsTop> implementedInterface();
    
    /**
     * Return chassis, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Data for chassis components
     *     </code>
     * </pre>
     *
     * @return {@code Chassis} chassis, or {@code null} if it is not present.
     *
     */
    Chassis getChassis();
    
    /**
     * Return chassis, or an empty instance if it is not present.
     *
     * @return {@code Chassis} chassis, or an empty instance if it is not present.
     *
     */
    @NonNull Chassis nonnullChassis();
    
    /**
     * Return port, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Data for physical port components
     *     </code>
     * </pre>
     *
     * @return {@code Port} port, or {@code null} if it is not present.
     *
     */
    Port getPort();
    
    /**
     * Return port, or an empty instance if it is not present.
     *
     * @return {@code Port} port, or an empty instance if it is not present.
     *
     */
    @NonNull Port nonnullPort();
    
    /**
     * Return powerSupply, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Data for power supply components
     *     </code>
     * </pre>
     *
     * @return {@code PowerSupply} powerSupply, or {@code null} if it is not present.
     *
     */
    PowerSupply getPowerSupply();
    
    /**
     * Return powerSupply, or an empty instance if it is not present.
     *
     * @return {@code PowerSupply} powerSupply, or an empty instance if it is not present.
     *
     */
    @NonNull PowerSupply nonnullPowerSupply();
    
    /**
     * Return fan, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Data for fan components
     *     </code>
     * </pre>
     *
     * @return {@code Fan} fan, or {@code null} if it is not present.
     *
     */
    Fan getFan();
    
    /**
     * Return fan, or an empty instance if it is not present.
     *
     * @return {@code Fan} fan, or an empty instance if it is not present.
     *
     */
    @NonNull Fan nonnullFan();
    
    /**
     * Return fabric, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Data for fabric components
     *     </code>
     * </pre>
     *
     * @return {@code Fabric} fabric, or {@code null} if it is not present.
     *
     */
    Fabric getFabric();
    
    /**
     * Return fabric, or an empty instance if it is not present.
     *
     * @return {@code Fabric} fabric, or an empty instance if it is not present.
     *
     */
    @NonNull Fabric nonnullFabric();
    
    /**
     * Return storage, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Data for storage components
     *     </code>
     * </pre>
     *
     * @return {@code Storage} storage, or {@code null} if it is not present.
     *
     */
    Storage getStorage();
    
    /**
     * Return storage, or an empty instance if it is not present.
     *
     * @return {@code Storage} storage, or an empty instance if it is not present.
     *
     */
    @NonNull Storage nonnullStorage();
    
    /**
     * Return cpu, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Data for cpu components
     *     </code>
     * </pre>
     *
     * @return {@code Cpu} cpu, or {@code null} if it is not present.
     *
     */
    Cpu getCpu();
    
    /**
     * Return cpu, or an empty instance if it is not present.
     *
     * @return {@code Cpu} cpu, or an empty instance if it is not present.
     *
     */
    @NonNull Cpu nonnullCpu();
    
    /**
     * Return integratedCircuit, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Data for chip components, such as ASIC, NPUs, etc.
     *     </code>
     * </pre>
     *
     * @return {@code IntegratedCircuit} integratedCircuit, or {@code null} if it is not present.
     *
     */
    IntegratedCircuit getIntegratedCircuit();
    
    /**
     * Return integratedCircuit, or an empty instance if it is not present.
     *
     * @return {@code IntegratedCircuit} integratedCircuit, or an empty instance if it is not present.
     *
     */
    @NonNull IntegratedCircuit nonnullIntegratedCircuit();
    
    /**
     * Return backplane, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Data for backplane components
     *     </code>
     * </pre>
     *
     * @return {@code Backplane} backplane, or {@code null} if it is not present.
     *
     */
    Backplane getBackplane();
    
    /**
     * Return backplane, or an empty instance if it is not present.
     *
     * @return {@code Backplane} backplane, or an empty instance if it is not present.
     *
     */
    @NonNull Backplane nonnullBackplane();
    
    /**
     * Return softwareModule, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Data for software module components, i.e., for components with
     *         type=SOFTWARE_MODULE
     *     </code>
     * </pre>
     *
     * @return {@code SoftwareModule} softwareModule, or {@code null} if it is not present.
     *
     */
    SoftwareModule getSoftwareModule();
    
    /**
     * Return softwareModule, or an empty instance if it is not present.
     *
     * @return {@code SoftwareModule} softwareModule, or an empty instance if it is not present.
     *
     */
    @NonNull SoftwareModule nonnullSoftwareModule();

}

